/*
 * Decompiled with CFR 0.152.
 */
package com.astrazoey.indexed;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigMain {
    private static final float MOD_VERSION = 1.7f;
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("indexed.properties");
    private static final String MOD_VERSION_KEY = "mod-version";
    private static float modVersion = 1.7f;
    public static final String ENABLE_CONFIG_UPDATES_KEY = "enable-config-updates";
    private static boolean enableConfigUpdates = true;
    public static final String ENABLE_ENCHANTMENT_NERFS_KEY = "enable-enchantment-nerfs";
    public static boolean enableEnchantmentNerfs = true;
    public static final String ENABLE_VILLAGER_NERFS_KEY = "enable-villager-nerfs";
    public static boolean enableVillagerNerfs = true;
    public static final String ENABLE_LINEAR_XP = "enable-linear-xp";
    public static boolean enableLinearXp = true;
    private static final String LINEAR_XP_AMOUNT = "linear-xp-amount";
    private static final int linearXpAmountDefault = 30;
    public static int linearXpAmount = 30;

    public static void save() {
        Properties props = new Properties();
        ConfigMain.read(props);
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try (OutputStream out = Files.newOutputStream(CONFIG_PATH, new OpenOption[0]);){
            props.store(out, "Indexed Configuration");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void load(boolean modOutOfDate) {
        if (modOutOfDate && Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                System.out.println("Mod is out of date! Resetting file!");
                modVersion = 1.7f;
                Files.delete(CONFIG_PATH);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Failed to delete config file.");
                return;
            }
        }
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                Files.createFile(CONFIG_PATH, new FileAttribute[0]);
                ConfigMain.save();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
            props.load(stream);
            ConfigMain.assign(props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isOutOfDate() {
        return modVersion != 1.7f && enableConfigUpdates;
    }

    public static void read(Properties props) {
        props.setProperty(MOD_VERSION_KEY, String.valueOf(modVersion));
        props.setProperty(ENABLE_CONFIG_UPDATES_KEY, String.valueOf(enableConfigUpdates));
        props.setProperty(ENABLE_ENCHANTMENT_NERFS_KEY, String.valueOf(enableEnchantmentNerfs));
        props.setProperty(ENABLE_VILLAGER_NERFS_KEY, String.valueOf(enableVillagerNerfs));
        props.setProperty(ENABLE_LINEAR_XP, String.valueOf(enableLinearXp));
        props.setProperty(LINEAR_XP_AMOUNT, String.valueOf(linearXpAmount));
    }

    public static void assign(Properties props) {
        modVersion = ConfigMain.defaultFloat(props.getProperty(MOD_VERSION_KEY), 1.7f);
        enableConfigUpdates = ConfigMain.defaultBoolean(props.getProperty(ENABLE_CONFIG_UPDATES_KEY), true);
        enableEnchantmentNerfs = ConfigMain.defaultBoolean(props.getProperty(ENABLE_ENCHANTMENT_NERFS_KEY), true);
        enableVillagerNerfs = ConfigMain.defaultBoolean(props.getProperty(ENABLE_VILLAGER_NERFS_KEY), true);
        enableLinearXp = ConfigMain.defaultBoolean(props.getProperty(ENABLE_LINEAR_XP), true);
        linearXpAmount = ConfigMain.defaultInt(props.getProperty(LINEAR_XP_AMOUNT), 30);
    }

    private static boolean defaultBoolean(String bool, boolean defaultOption) {
        return bool == null ? defaultOption : Boolean.parseBoolean(bool);
    }

    private static float defaultFloat(String amount, float defaultOption) {
        return amount == null ? defaultOption : Float.parseFloat(amount);
    }

    private static int defaultInt(String amount, int defaultOption) {
        return amount == null ? defaultOption : Integer.parseInt(amount);
    }
}

