/*
 * Decompiled with CFR 0.152.
 */
package com.astrazoey.indexed;

import com.astrazoey.indexed.AnvilScreenClassVisitor;
import com.astrazoey.indexed.ClassTransformer;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.IExtensionRegistry;

public final class TransformerMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger(TransformerMixinPlugin.class);

    public void onLoad(String mixinPackage) {
        FabricLoader loader = FabricLoader.getInstance();
        MappingResolver mappings = loader.getMappingResolver();
        ClassTransformer transformer = AnvilScreenClassVisitor.createTransformer(mappings);
        try {
            this.registerClassTransformer(transformer);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Failed to apply class transformer!", (Throwable)e);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return ImmutableList.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private void registerClassTransformer(ClassTransformer transformer) throws ReflectiveOperationException {
        HackerVoice.imIn().registerTransformer(transformer);
    }

    private record HackerVoice(Object delegate, Field mixinTransformerField) {
        static HackerVoice imIn() throws ReflectiveOperationException {
            Class<?> knotClassLoader = Class.forName("net.fabricmc.loader.impl.launch.knot.KnotClassLoader");
            Class<?> knotClassDelegate = Class.forName("net.fabricmc.loader.impl.launch.knot.KnotClassDelegate");
            Field delegateField = knotClassLoader.getDeclaredField("delegate");
            delegateField.setAccessible(true);
            Field mixinTransformerField = knotClassDelegate.getDeclaredField("mixinTransformer");
            mixinTransformerField.setAccessible(true);
            Object delegate = delegateField.get(HackerVoice.class.getClassLoader());
            return new HackerVoice(delegate, mixinTransformerField);
        }

        void registerTransformer(ClassTransformer transformer) throws IllegalAccessException {
            IMixinTransformer mixinTransformer = (IMixinTransformer)this.mixinTransformerField.get(this.delegate);
            if (mixinTransformer == null) {
                throw new IllegalStateException("mixin transformer not yet initialized!");
            }
            this.mixinTransformerField.set(this.delegate, new ProxyMixinTransformer(mixinTransformer, transformer));
        }
    }

    record ProxyMixinTransformer(IMixinTransformer delegate, ClassTransformer transformer) implements IMixinTransformer
    {
        public void audit(MixinEnvironment environment) {
            this.delegate.audit(environment);
        }

        public List<String> reload(String mixinClass, ClassNode classNode) {
            return this.delegate.reload(mixinClass, classNode);
        }

        public boolean computeFramesForClass(MixinEnvironment environment, String name, ClassNode classNode) {
            return this.delegate.computeFramesForClass(environment, name, classNode);
        }

        public byte[] transformClassBytes(String name, String transformedName, byte[] basicClass) {
            byte[] bytes = this.delegate.transformClassBytes(name, transformedName, basicClass);
            bytes = this.transformer.transform(name, transformedName, bytes);
            return bytes;
        }

        public byte[] transformClass(MixinEnvironment environment, String name, byte[] classBytes) {
            return this.delegate.transformClass(environment, name, classBytes);
        }

        public boolean transformClass(MixinEnvironment environment, String name, ClassNode classNode) {
            return this.delegate.transformClass(environment, name, classNode);
        }

        public boolean couldTransformClass(MixinEnvironment environment, String s) {
            return this.delegate.couldTransformClass(environment, s);
        }

        public byte[] generateClass(MixinEnvironment environment, String name) {
            return this.delegate.generateClass(environment, name);
        }

        public boolean generateClass(MixinEnvironment environment, String name, ClassNode classNode) {
            return this.delegate.generateClass(environment, name, classNode);
        }

        public IExtensionRegistry getExtensions() {
            return this.delegate.getExtensions();
        }
    }
}

