/*
 * Decompiled with CFR 0.152.
 */
package com.astrazoey.indexed.mixins;

import com.astrazoey.indexed.Indexed;
import com.astrazoey.indexed.MaxEnchantingSlots;
import com.astrazoey.indexed.registry.IndexedItems;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1731;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_6880;
import net.minecraft.class_8047;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1706.class}, priority=999)
public abstract class AnvilScreenHandlerMixin
extends class_4861 {
    class_1799 itemStack1;
    class_1799 itemStack3;
    int enchantLevel1;
    int enchantLevel2;
    boolean overcharged = false;
    int repairCost = 1;
    int repairScaling = 6;

    public AnvilScreenHandlerMixin(@Nullable class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context, class_8047 forgingSlotsManager) {
        super(type, syncId, playerInventory, context, forgingSlotsManager);
    }

    @Redirect(method={"updateResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/Inventory;getStack(I)Lnet/minecraft/item/ItemStack;", ordinal=0))
    public class_1799 getItemStack1(class_1263 inventory, int slot) {
        this.itemStack1 = inventory.method_5438(0);
        return this.itemStack1;
    }

    @Redirect(method={"updateResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/Inventory;getStack(I)Lnet/minecraft/item/ItemStack;", ordinal=1))
    public class_1799 getItemStack3(class_1263 inventory, int slot) {
        this.itemStack3 = inventory.method_5438(1);
        return this.itemStack3;
    }

    public int calculateRepairCost() {
        if (MaxEnchantingSlots.getEnchantType(this.itemStack1) != null) {
            float enchantingRatio = (float)MaxEnchantingSlots.getCurrent(this.itemStack1) / (float)MaxEnchantingSlots.getEnchantType(this.itemStack1).getMaxEnchantingSlots();
            float enchantingFactor = enchantingRatio * (float)this.repairScaling;
            enchantingFactor = Math.round(enchantingFactor);
            enchantingFactor *= MaxEnchantingSlots.getEnchantType(this.itemStack1).getRepairScaling();
            if ((enchantingFactor -= (float)(Indexed.getEnchantmentValue(Indexed.REDUCE_REPAIR_COST, this.field_22482.method_73183(), this.itemStack1) * 3) * MaxEnchantingSlots.getEnchantType(this.itemStack1).getRepairScaling()) < 0.0f) {
                enchantingFactor = 0.0f;
            }
            return this.repairCost + (int)enchantingFactor;
        }
        return 4;
    }

    @ModifyConstant(method={"updateResult"}, constant={@Constant(intValue=4, ordinal=0)})
    public int increaseRepairCost(int cost) {
        return this.calculateRepairCost();
    }

    @ModifyConstant(method={"updateResult"}, constant={@Constant(intValue=4, ordinal=1)})
    public int increaseRepairCost2(int cost) {
        return this.calculateRepairCost();
    }

    @Redirect(method={"updateResult"}, at=@At(value="INVOKE", target="Ljava/lang/Math;max(II)I", ordinal=0))
    public int linearEnchantment(int a, int b) {
        return a + b;
    }

    @Redirect(method={"updateResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/component/type/ItemEnchantmentsComponent$Builder;getLevel(Lnet/minecraft/registry/entry/RegistryEntry;)I"))
    public int getQ(class_9304.class_9305 instance, class_6880<class_1887> enchantment) {
        this.enchantLevel2 = instance.method_57546(enchantment);
        return this.enchantLevel2;
    }

    @ModifyConstant(method={"updateResult"}, constant={@Constant(intValue=1, ordinal=2)})
    public int linearEnchantmentSameValue(int q) {
        return this.enchantLevel2;
    }

    @ModifyConstant(method={"updateResult"}, constant={@Constant(expandZeroConditions={Constant.Condition.LESS_THAN_OR_EQUAL_TO_ZERO}, ordinal=2)})
    public int allowAnyCost(int i) {
        if (this.itemStack3.method_7960()) {
            return 0;
        }
        return -1;
    }

    @ModifyConstant(method={"canTakeOutput"}, constant={@Constant(expandZeroConditions={Constant.Condition.GREATER_THAN_ZERO})})
    public int allowAnyCostForOutput(int cost) {
        if (this.overcharged) {
            return 50000;
        }
        return -1;
    }

    @Redirect(method={"updateResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/CraftingResultInventory;setStack(ILnet/minecraft/item/ItemStack;)V", ordinal=4))
    public void denyExpensiveTransactions(class_1731 craftingResultInventory, int slot, class_1799 stack) {
        if (MaxEnchantingSlots.getEnchantType(stack) != null) {
            if (MaxEnchantingSlots.getCurrent(stack) > MaxEnchantingSlots.getEnchantType(stack).getMaxEnchantingSlots()) {
                this.overcharged = true;
                craftingResultInventory.method_5447(slot, stack);
            } else {
                this.overcharged = false;
                craftingResultInventory.method_5447(slot, stack);
            }
        } else {
            craftingResultInventory.method_5447(slot, stack);
        }
    }

    @Redirect(method={"updateResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;set(Lnet/minecraft/component/ComponentType;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    public <T> Object removeTooExpensiveLimit(class_1799 itemStack, class_9331<T> type, T repairCost) {
        if ((Integer)repairCost > 30) {
            itemStack.method_57379(class_9334.field_49639, (Object)30);
        } else {
            itemStack.method_57379(class_9334.field_49639, (Object)((Integer)repairCost));
        }
        return null;
    }

    @Redirect(method={"updateResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/Property;set(I)V", ordinal=5))
    public void freeRepairCost(class_3915 property, int value) {
        if (this.itemStack3.method_7909() != class_1802.field_8598 && this.itemStack3.method_7909() != this.itemStack1.method_7909()) {
            property.method_17404(0);
        } else {
            int maxRepairCost = 30 - Indexed.getEnchantmentValue(Indexed.REDUCE_REPAIR_COST, this.field_22482.method_73183(), this.itemStack1) * 5;
            if (value > maxRepairCost) {
                property.method_17404(maxRepairCost);
            } else {
                property.method_17404(value);
            }
        }
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/Inventory;getStack(I)Lnet/minecraft/item/ItemStack;")})
    public void grantRepairAdvancement(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (player instanceof class_3222) {
            System.out.println("Grant repair activated.");
            Indexed.REPAIR_ITEM.trigger((class_3222)player);
        }
    }

    @Redirect(method={"updateResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;canRepairWith(Lnet/minecraft/item/ItemStack;)Z"))
    public boolean repairable(class_1799 stack, class_1799 ingredient) {
        return stack.method_7963() && ingredient.method_31574(IndexedItems.VITALIS);
    }
}

