/*
 * Decompiled with CFR 0.152.
 */
package com.astrazoey.indexed.mixins;

import com.astrazoey.indexed.Indexed;
import com.astrazoey.indexed.registry.IndexedItems;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1890.class})
public class EnchantmentHelperMixin {
    private static ThreadLocal<class_1799> generatedItemType = new ThreadLocal();

    @Inject(method={"generateEnchantments"}, at={@At(value="HEAD")})
    private static void getItemStack(class_5819 random, class_1799 stack, int level, Stream<class_6880<class_1887>> possibleEnchantments, CallbackInfoReturnable<List<class_1889>> cir) {
        generatedItemType.set(stack);
    }

    @ModifyConstant(method={"generateEnchantments"}, constant={@Constant(intValue=50, ordinal=0)})
    private static int increaseGoldBookEffectiveness(int constant) {
        if (generatedItemType.get().method_31574(IndexedItems.GOLD_BOUND_BOOK)) {
            return 10;
        }
        return constant;
    }

    @Inject(method={"getAmmoUse"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onStoppedUsing(class_3218 world, class_1799 rangedWeaponStack, class_1799 projectileStack, int baseAmmoUse, CallbackInfoReturnable<Integer> cir) {
        int infinityLevel = Indexed.getEnchantmentValue(Indexed.REPLENISH_PROJECTILE, world, rangedWeaponStack);
        System.out.println("infinity level is " + infinityLevel);
        double infinityChance = 0.5 + (double)infinityLevel * 0.1;
        System.out.println("infinity chance is + " + infinityChance);
        double randomNumber = Math.random();
        System.out.println("random number is " + randomNumber);
        if (infinityChance > randomNumber && infinityLevel > 0) {
            System.out.println("infinity triggered");
            cir.setReturnValue((Object)0);
        }
    }

    @Inject(method={"getPossibleEntries"}, at={@At(value="HEAD")}, cancellable=true)
    private static void checkAcceptableEnchantments(int level, class_1799 stack, Stream<class_6880<class_1887>> possibleEnchantments, CallbackInfoReturnable<List<class_1889>> cir) {
        ArrayList returnList = Lists.newArrayList();
        boolean bl = stack.method_31574(class_1802.field_8529) || stack.method_31574(IndexedItems.GOLD_BOUND_BOOK);
        possibleEnchantments.filter(enchantment -> EnchantmentHelperMixin.doStuff((class_6880<class_1887>)enchantment, stack) || bl).forEach(enchantmentx -> {
            class_1887 enchantment = (class_1887)enchantmentx.comp_349();
            int maxLevel = enchantment.method_8183();
            int minLevel = enchantment.method_8187();
            if (enchantment.comp_2689().method_57832(Indexed.REDUCE_REPAIR_COST)) {
                maxLevel = 1;
            } else if (enchantmentx.method_40225(class_1893.field_9119)) {
                maxLevel = 3;
            } else if (enchantmentx.method_40225(class_1893.field_9101)) {
                maxLevel = 2;
            }
            for (int j = maxLevel; j >= minLevel; --j) {
                if (level < enchantment.method_8182(j) || level > enchantment.method_20742(j)) continue;
                returnList.add(new class_1889(enchantmentx, j));
                break;
            }
        });
        cir.setReturnValue((Object)returnList);
    }

    @Unique
    private static boolean doStuff(class_6880<class_1887> enchantment, class_1799 stack) {
        if (stack.method_31574(IndexedItems.GOLD_BOUND_BOOK) && (((class_1887)enchantment.comp_349()).comp_2689().method_57832(Indexed.REDUCE_REPAIR_COST) || enchantment.method_40225(class_1893.field_9119) || enchantment.method_40225(class_1893.field_9101))) {
            System.out.println("Excluded enchantment: " + String.valueOf(enchantment));
            return false;
        }
        return ((class_1887)enchantment.comp_349()).method_58444(stack);
    }
}

