/*
 * Decompiled with CFR 0.152.
 */
package com.astrazoey.indexed.blocks;

import com.astrazoey.indexed.Indexed;
import com.astrazoey.indexed.registry.IndexedItems;
import com.astrazoey.indexed.registry.IndexedParticles;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.ToIntFunction;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9636;

public class CrystalGlobeBlock
extends class_2248 {
    public static final int MAX_LEVEL = 8;
    public static final class_2758 LEVEL = class_2741.field_17586;
    public static final ToIntFunction<class_2680> STATE_TO_LUMINANCE = state -> 2 * (Integer)state.method_11654((class_2769)LEVEL);

    public CrystalGlobeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        class_265 base = class_259.method_1081((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)0.875);
        class_265 stand = class_259.method_1081((double)0.375, (double)0.125, (double)0.375, (double)0.625, (double)0.25, (double)0.625);
        class_265 head = class_259.method_1081((double)0.1875, (double)0.25, (double)0.1875, (double)0.8125, (double)0.875, (double)0.8125);
        return class_259.method_1084((class_265)head, (class_265)class_259.method_1084((class_265)base, (class_265)stand));
    }

    private double lerpDouble(double start, double finish, double alpha) {
        return start + alpha * (finish - start);
    }

    private class_243 lerpVector(class_243 start, class_243 finish, double alpha) {
        return new class_243(this.lerpDouble(start.field_1352, finish.field_1352, alpha), this.lerpDouble(start.field_1351, finish.field_1351, alpha), this.lerpDouble(start.field_1350, finish.field_1350, alpha));
    }

    private void crystalUseEffects(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8396(null, pos, Indexed.CRYSTAL_USE_SOUND_EVENT, class_3419.field_15245, 0.2f, this.getRandomPitch(world));
        if (world instanceof class_3218) {
            ((class_3218)world).method_65096((class_2394)IndexedParticles.CRYSTAL_BREAK, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 20, 0.25, 0.25, 0.25, 0.0);
        }
    }

    public class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5998(hand).method_7942() || player.method_5998(hand).method_31574(class_1802.field_8598)) {
            class_1799 heldItem = player.method_5998(hand);
            class_9304 heldEnchantments = class_1890.method_57532((class_1799)heldItem);
            class_9304.class_9305 newEnchantments = new class_9304.class_9305(class_1890.method_57532((class_1799)heldItem));
            int totalEnchants = 0;
            for (Object2IntMap.Entry entry : heldEnchantments.method_57539()) {
                class_6880 enchantmentEntry = (class_6880)entry.getKey();
                int enchantmentLevel = heldEnchantments.method_57536(enchantmentEntry);
                if (enchantmentEntry.method_40220(class_9636.field_51551)) {
                    newEnchantments.method_57547(enchantmentEntry, enchantmentLevel);
                } else {
                    --enchantmentLevel;
                    this.incrementCrystalLevel(state, world, pos);
                    ++totalEnchants;
                }
                newEnchantments.method_57547(enchantmentEntry, enchantmentLevel);
            }
            class_1890.method_57530((class_1799)heldItem, (class_9304)newEnchantments.method_57549());
            if (heldItem.method_31574(class_1802.field_8598) && class_1890.method_57532((class_1799)heldItem).method_57543()) {
                class_1799 newItem = heldItem.method_56701((class_1935)class_1802.field_8529, heldItem.method_7947());
                player.method_6122(hand, newItem);
            }
            if (totalEnchants > 0) {
                this.crystalUseEffects(state, world, pos);
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        if (player.method_6047().method_7960() && (Integer)state.method_11654((class_2769)LEVEL) >= 8) {
            world.method_8396(null, pos, Indexed.CRYSTAL_HARVEST_SOUND_EVENT, class_3419.field_15245, 1.0f, this.getRandomPitch(world));
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0)), 3);
            if (!player.method_73183().method_8608()) {
                class_1293 statusEffectInstance = new class_1293(Indexed.ENCHANTED_STATUS_EFFECT, 6000);
                player.method_6092(statusEffectInstance);
            }
            if (world instanceof class_3218) {
                this.method_9583((class_3218)world, pos, this.getCrystalPower(world, pos));
            }
            if (player instanceof class_3222) {
                Indexed.USE_CRYSTAL_GLOBE.trigger((class_3222)player);
            }
            return class_1269.field_5812;
        }
        if (player.method_5998(hand).method_31574(IndexedItems.VITALIS) || player.method_5998(hand).method_31574(class_1802.field_38746)) {
            this.crystalUseEffects(state, world, pos);
            if (world instanceof class_3218) {
                this.method_9583((class_3218)world, pos, 10);
            }
            if (!player.method_68878()) {
                player.method_5998(hand).method_7934(1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private int getCrystalPower(class_1937 world, class_2338 pos) {
        return 30;
    }

    private void incrementCrystalLevel(class_2680 state, class_1937 world, class_2338 pos) {
        int i = (Integer)state.method_11654((class_2769)LEVEL);
        if (i < 8 && world.method_8409().method_43048(100) <= this.getCrystalPower(world, pos) && !world.method_8608()) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(++i)), 3);
        }
    }

    private boolean destroyAmethyst(class_2338.class_2339 checkedPos, class_2338 pos, class_1937 world) {
        int random = world.method_8409().method_43048(100);
        if (random <= 12) {
            if (!world.method_8608()) {
                world.method_30093((class_2338)checkedPos, true, null, 3);
                class_243 positionOne = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                class_243 positionTwo = new class_243((double)checkedPos.method_10263(), (double)checkedPos.method_10264(), (double)checkedPos.method_10260());
                for (double alpha = 0.0; alpha <= 1.0; alpha += 0.025) {
                    class_243 positionLerp = this.lerpVector(positionOne, positionTwo, alpha);
                    if (!(world instanceof class_3218)) continue;
                    ((class_3218)world).method_65096((class_2394)IndexedParticles.CRYSTAL_BREAK, positionLerp.field_1352 + 0.5, positionLerp.field_1351 + 0.5, positionLerp.field_1350 + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    private int countAmethystClusters(class_2338 pos, class_1937 world, boolean destroyAmethyst) {
        int scanSize = 3;
        int clusterCount = 0;
        int amethystBroken = 0;
        class_2338.class_2339 checkedPos = pos.method_25503();
        checkedPos = checkedPos.method_10100(-scanSize, 0, -scanSize);
        for (int i = -scanSize; i <= scanSize; ++i) {
            for (int j = -scanSize; j <= scanSize; ++j) {
                if (this.isAmethystCluster(world.method_8320((class_2338)checkedPos))) {
                    ++clusterCount;
                    if (destroyAmethyst && amethystBroken < 3 && this.destroyAmethyst(checkedPos, pos, world)) {
                        ++amethystBroken;
                    }
                }
                checkedPos = checkedPos.method_10100(1, 0, 0);
            }
            checkedPos = checkedPos.method_10100(-scanSize * 2 - 1, 0, 1);
        }
        return clusterCount;
    }

    private boolean isAmethystCluster(class_2680 state) {
        return state.method_26204() == class_2246.field_27164 || state.method_26204() == class_2246.field_27163 || state.method_26204() == class_2246.field_27162 || state.method_26204() == class_2246.field_27161;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(3) == 0 && (Integer)state.method_11654((class_2769)LEVEL) >= 8) {
            world.method_8406((class_2394)IndexedParticles.CRYSTAL_HARVEST, (double)((float)pos.method_10263() + world.method_8409().method_43057() * 1.0f), (double)((float)pos.method_10264() + world.method_8409().method_43057() * 1.0f), (double)((float)pos.method_10260() + world.method_8409().method_43057() * 1.0f), random.method_43059() * 0.005, random.method_43059() * 0.005, random.method_43059() * 0.005);
        }
        if (random.method_43048(24) == 0 && (Integer)state.method_11654((class_2769)LEVEL) >= 8) {
            world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), Indexed.CRYSTAL_AMBIENT_SOUND_EVENT, class_3419.field_15245, 2.0f, this.getRandomPitch(world), true);
        }
    }

    private float getRandomPitch(class_1937 world) {
        return 0.8f + world.method_8409().method_43057() * 0.4f;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LEVEL});
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return (Integer)state.method_11654((class_2769)LEVEL);
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }
}

