/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.List;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.network.PacketVariablesReady;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGetVariables(ResourceKey<Level> level, BlockPos pos, TypedMap params, Boolean fromTablet) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolscontrol", (String)"getvariables");
    public static final CustomPacketPayload.Type<PacketGetVariables> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketGetVariables> CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeResourceLocation(packet.level.location());
        buf.writeBlockPos(packet.pos);
        TypedMap.STREAM_CODEC.encode(buf, (Object)packet.params);
        buf.writeBoolean(packet.fromTablet.booleanValue());
    }, buf -> new PacketGetVariables((ResourceKey<Level>)LevelTools.getId((ResourceLocation)buf.readResourceLocation()), buf.readBlockPos(), (TypedMap)TypedMap.STREAM_CODEC.decode(buf), buf.readBoolean()));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketGetVariables create(BlockPos pos, ResourceKey<Level> type, boolean fromTablet) {
        return new PacketGetVariables(type, pos, TypedMap.EMPTY, fromTablet);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity te;
            ServerLevel world = LevelTools.getLevel((Level)ctx.player().getCommandSenderWorld(), this.level);
            if (world.hasChunkAt(this.pos) && (te = world.getBlockEntity(this.pos)) instanceof GenericTileEntity) {
                List list = ((GenericTileEntity)te).executeServerCommandList(ProcessorTileEntity.CMD_GETVARS.name(), ctx.player(), this.params, Parameter.class);
                RFToolsCtrlMessages.sendToPlayer(new PacketVariablesReady(this.fromTablet != false ? null : this.pos, ProcessorTileEntity.CMD_GETVARS.name(), list), ctx.player());
            }
        });
    }
}

