/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.programmer.network;

import mcjty.rftoolscontrol.modules.programmer.blocks.ProgrammerTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUpdateNBTItemInventoryProgrammer(BlockPos pos, int slotIndex, ItemStack card) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolscontrol", (String)"updatenbtiteminventoryprogrammer");
    public static final CustomPacketPayload.Type<PacketUpdateNBTItemInventoryProgrammer> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateNBTItemInventoryProgrammer> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketUpdateNBTItemInventoryProgrammer::pos, (StreamCodec)ByteBufCodecs.INT, PacketUpdateNBTItemInventoryProgrammer::slotIndex, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, PacketUpdateNBTItemInventoryProgrammer::card, PacketUpdateNBTItemInventoryProgrammer::new);

    public static PacketUpdateNBTItemInventoryProgrammer create(BlockPos blockPos, int slot, ItemStack card) {
        return new PacketUpdateNBTItemInventoryProgrammer(blockPos, slot, card);
    }

    protected boolean isValidBlock(Level world, BlockPos blockPos, BlockEntity tileEntity) {
        return tileEntity instanceof ProgrammerTileEntity;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Level world = ctx.player().getCommandSenderWorld();
            BlockEntity te = world.getBlockEntity(this.pos);
            if (te != null) {
                if (!this.isValidBlock(world, this.pos, te)) {
                    return;
                }
                IItemHandler handler = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, this.pos, null);
                if (handler != null) {
                    ItemStack stack = handler.getStackInSlot(this.slotIndex);
                    if (stack.getItem() == this.card.getItem()) {
                        stack.applyComponents(this.card.getComponents());
                    }
                    te.setChanged();
                }
            }
        });
    }
}

