/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.crafting.BaseRecipe;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.blocks.WorkbenchContainer;
import mcjty.rftoolscontrol.modules.various.data.WorkbenchData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.Lazy;

public class WorkbenchTileEntity
extends GenericTileEntity {
    public static final int SLOT_CRAFTINPUT = 0;
    public static final int SLOT_CRAFTOUTPUT = 9;
    public static final int SLOT_BUFFER = 10;
    public static final int BUFFER_SIZE = 27;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(37).box(SlotDefinition.generic(), 0, 42, 27, 3, 3).box(SlotDefinition.craftResult().onCraft((tileEntity, playerEntity, stack) -> ((WorkbenchTileEntity)((Object)((Object)tileEntity))).craftItem()), 9, 114, 45, 1, 1).box(SlotDefinition.generic(), 10, 6, 99, 9, 3).playerSlots(6, 157));
    private final GenericItemHandler items = this.createItemHandler();
    private final WorkbenchItemHandler automationItemHandlerUp = new WorkbenchItemHandler(this.items, Direction.UP);
    private final WorkbenchItemHandler automationItemHandlerDown = new WorkbenchItemHandler(this.items, Direction.DOWN);
    private final WorkbenchItemHandler automationItemHandlerSide = new WorkbenchItemHandler(this.items, null);
    @Cap(type=CapType.CONTAINER)
    private static final Function<WorkbenchTileEntity, MenuProvider> SCREEN_CAP = tile -> new DefaultContainerProvider("Workbench").containerSupplier((windowId, player) -> new WorkbenchContainer((int)windowId, (ContainerFactory)CONTAINER_FACTORY.get(), tile.getBlockPos(), (GenericTileEntity)tile, (Player)player)).itemHandler(() -> tile.items);

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, blockEntity, direction) -> {
            if (blockEntity instanceof WorkbenchTileEntity) {
                WorkbenchTileEntity workbench = (WorkbenchTileEntity)blockEntity;
                if (direction == Direction.DOWN) {
                    return workbench.automationItemHandlerDown;
                }
                if (direction == Direction.UP) {
                    return workbench.automationItemHandlerUp;
                }
                return workbench.automationItemHandlerSide;
            }
            return null;
        }, new Block[]{(Block)VariousModule.WORKBENCH.block().get()});
    }

    public WorkbenchTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VariousModule.WORKBENCH.be().get(), pos, state);
    }

    private boolean isCraftInputSlot(int slot) {
        return slot >= 0 && slot < 9;
    }

    private boolean isBufferSlot(int slot) {
        return slot >= 10 && slot < 37;
    }

    private boolean isCraftOutput(int slot) {
        return slot == 9;
    }

    @Nullable
    private Recipe findRecipe(CraftingInput workInventory) {
        RecipeManager manager = this.level.getRecipeManager();
        for (RecipeHolder rh : manager.getRecipes()) {
            Recipe r = rh.value();
            if (r == null || !RecipeType.CRAFTING.equals((Object)r.getType()) || !r.matches((RecipeInput)workInventory, this.level)) continue;
            return r;
        }
        return null;
    }

    private void updateRecipe() {
        if (this.items.getStackInSlot(9).isEmpty() || this.getRealItems() == 0) {
            CraftingInput workInventory = this.makeWorkInventory();
            Recipe recipe = this.findRecipe(workInventory);
            if (recipe != null) {
                ItemStack stack = BaseRecipe.assemble((Recipe)recipe, (RecipeInput)workInventory, (Level)this.level);
                this.items.setStackInSlot(9, stack);
                this.setRealItems(stack.isEmpty() ? 0 : stack.getCount());
            } else {
                this.items.setStackInSlot(9, ItemStack.EMPTY);
                this.setRealItems(0);
            }
        }
    }

    private static List<ItemStack> createList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            list.add(ItemStack.EMPTY);
        }
        return list;
    }

    private CraftingInput makeWorkInventory() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            items.add(i, (ItemStack)items.get(i + 0));
        }
        return CraftingInput.of((int)3, (int)3, items);
    }

    public void craftItem() {
    }

    private GenericItemHandler createItemHandler() {
        return new GenericItemHandler(this, (ContainerFactory)CONTAINER_FACTORY.get()){
            private int crafting;
            {
                this.crafting = 0;
            }

            protected void onUpdate(int index, ItemStack stack) {
                if (WorkbenchTileEntity.this.isCraftInputSlot(index) && this.crafting <= 0) {
                    WorkbenchTileEntity.this.updateRecipe();
                }
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                CraftingInput workInventory;
                Recipe recipe;
                if (simulate) {
                    return super.extractItem(slot, amount, simulate);
                }
                if (WorkbenchTileEntity.this.isCraftOutput(slot) && WorkbenchTileEntity.this.getRealItems() == 0 && (recipe = WorkbenchTileEntity.this.findRecipe(workInventory = WorkbenchTileEntity.this.makeWorkInventory())) != null) {
                    ++this.crafting;
                    NonNullList remainingItems = recipe.getRemainingItems((RecipeInput)workInventory);
                    for (int i = 0; i < 9; ++i) {
                        ItemStack s = WorkbenchTileEntity.this.items.getStackInSlot(i + 0);
                        if (!s.isEmpty()) {
                            super.extractItem(i + 0, 1, false);
                            s = WorkbenchTileEntity.this.items.getStackInSlot(i + 0);
                        }
                        if (((ItemStack)remainingItems.get(i)).isEmpty()) continue;
                        if (s.isEmpty()) {
                            WorkbenchTileEntity.this.items.setStackInSlot(i + 0, (ItemStack)remainingItems.get(i));
                            continue;
                        }
                        if (!ItemStack.isSameItem((ItemStack)s, (ItemStack)((ItemStack)remainingItems.get(i))) || !ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)((ItemStack)remainingItems.get(i)))) continue;
                        ItemStack stack = (ItemStack)remainingItems.get(i);
                        stack.grow(s.getCount());
                        WorkbenchTileEntity.this.items.setStackInSlot(i + 0, (ItemStack)remainingItems.get(i));
                    }
                    --this.crafting;
                }
                ItemStack rc = super.extractItem(slot, amount, false);
                if (WorkbenchTileEntity.this.isCraftOutput(slot)) {
                    ItemStack stack = WorkbenchTileEntity.this.items.getStackInSlot(slot);
                    WorkbenchTileEntity.this.setRealItems(stack.isEmpty() ? 0 : stack.getCount());
                }
                if (WorkbenchTileEntity.this.isCraftInputSlot(slot) || WorkbenchTileEntity.this.isCraftOutput(slot)) {
                    WorkbenchTileEntity.this.updateRecipe();
                }
                return rc;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }
        };
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((DataComponentType)VariousModule.ITEM_WORKBENCH_DATA.get(), (Object)this.getWorkbenchData());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        WorkbenchData data = (WorkbenchData)input.get((DataComponentType)VariousModule.ITEM_WORKBENCH_DATA.get());
        if (data != null) {
            this.setData(VariousModule.WORKBENCH_DATA.get(), data);
        }
    }

    private int getRealItems() {
        return this.getWorkbenchData().realItems();
    }

    private void setRealItems(int realItems) {
        WorkbenchData data = this.getWorkbenchData();
        if (data.realItems() != realItems) {
            this.setData(VariousModule.WORKBENCH_DATA.get(), data.withRealItems(realItems));
            this.setChanged();
        }
    }

    private WorkbenchData getWorkbenchData() {
        WorkbenchData data = (WorkbenchData)this.getData(VariousModule.WORKBENCH_DATA.get());
        if (data == null) {
            data = WorkbenchData.createDefault();
            this.setData(VariousModule.WORKBENCH_DATA.get(), data);
        }
        return data;
    }

    public class WorkbenchItemHandler
    extends AutomationFilterItemHander {
        private final Direction direction;

        public WorkbenchItemHandler(@Nullable GenericItemHandler wrapped, Direction direction) {
            super(wrapped);
            this.direction = direction;
        }

        public boolean canAutomationInsert(int index) {
            if (this.direction == null) {
                return !WorkbenchTileEntity.this.isCraftOutput(index);
            }
            if (this.direction == Direction.DOWN) {
                return false;
            }
            if (this.direction == Direction.UP) {
                return WorkbenchTileEntity.this.isCraftInputSlot(index);
            }
            return WorkbenchTileEntity.this.isBufferSlot(index);
        }

        public boolean canAutomationExtract(int index) {
            if (this.direction == null) {
                return true;
            }
            if (this.direction == Direction.DOWN) {
                return WorkbenchTileEntity.this.isCraftOutput(index);
            }
            if (this.direction == Direction.UP) {
                return WorkbenchTileEntity.this.isCraftInputSlot(index);
            }
            return WorkbenchTileEntity.this.isBufferSlot(index);
        }
    }
}

