/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.consolemodule;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.client.GuiTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorContainer;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.items.consolemodule.ConsoleClientScreenModule;
import mcjty.rftoolscontrol.modules.various.items.consolemodule.ConsoleScreenModule;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ConsoleModuleItem
extends GenericModuleItem
implements ITabletSupport {
    public ConsoleModuleItem() {
        super(RFToolsControl.setup.defaultProperties().stacksTo(1).durability(1));
    }

    @Nullable
    public Codec<? extends IScreenModule<?, ?>> codec() {
        return ConsoleScreenModule.CODEC;
    }

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return ConsoleScreenModule.STREAM_CODEC;
    }

    @Nullable
    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)VariousModule.CONSOLE_MODULE_DATA.get();
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return ConsoleScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new ConsoleClientScreenModule();
    }

    public Item getInstalledTablet() {
        return (Item)VariousModule.TABLET_PROCESSOR.get();
    }

    public void openGui(@Nonnull Player player, @Nonnull ItemStack tabletItem, @Nonnull ItemStack containingItem) {
        final BlockPos pos = ModuleTools.getPositionFromModule((ItemStack)containingItem);
        ResourceKey dimensionType = ModuleTools.getDimensionFromModule((ItemStack)containingItem);
        GuiTools.openRemoteGui((Player)player, (ResourceKey)dimensionType, (BlockPos)pos, te -> new MenuProvider(){
            final /* synthetic */ BlockEntity val$te;
            {
                this.val$te = blockEntity;
            }

            @Nonnull
            public Component getDisplayName() {
                return ComponentFactory.literal((String)"Remote Processor Console");
            }

            @Nonnull
            public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
                ProcessorContainer container = ProcessorContainer.createRemote(id, pos, (GenericTileEntity)this.val$te, player);
                IItemHandler handler = (IItemHandler)this.val$te.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.val$te.getBlockPos(), null);
                if (handler != null) {
                    container.setupInventories(handler, inventory);
                }
                return container;
            }
        });
    }

    protected int getUses(ItemStack stack) {
        return (Integer)Config.CONSOLEMODULE_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !BlockPosTools.isValid((BlockPos)ConsoleModuleItem.consoleData(stack).getCoordinate());
    }

    protected String getInfoString(ItemStack stack) {
        ConsoleScreenModule data = ConsoleModuleItem.consoleData(stack);
        return ModuleTools.getTargetString((String)"Processor", (GlobalPos)GlobalPos.of(data.getDim(), (BlockPos)data.getCoordinate()));
    }

    public String getModuleName() {
        return "VAR";
    }

    public static ConsoleScreenModule consoleData(ItemStack stack) {
        ConsoleScreenModule data = (ConsoleScreenModule)stack.get(VariousModule.CONSOLE_MODULE_DATA);
        if (data == null) {
            data = ConsoleScreenModule.DEFAULT;
        }
        return data;
    }

    public static void consoleData(ItemStack stack, Function<ConsoleScreenModule, ConsoleScreenModule> setter) {
        ConsoleScreenModule data = ConsoleModuleItem.consoleData(stack);
        data = setter.apply(data);
        stack.set((DataComponentType)VariousModule.CONSOLE_MODULE_DATA.get(), (Object)data);
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Block:").block(stack -> GlobalPos.of(ConsoleModuleItem.consoleData(stack).getDim(), (BlockPos)ConsoleModuleItem.consoleData(stack).getCoordinate()), stack -> "Processor").nl();
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = player.getItemInHand(hand);
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        ConsoleScreenModule data = ConsoleModuleItem.consoleData(stack);
        if (block == ProcessorModule.PROCESSOR.block().get()) {
            data = data.withDim((ResourceKey<Level>)world.dimension());
            data = data.withCoordinate(pos);
            String name = Tools.getReadableName((Level)world, (BlockPos)pos);
            ModuleTools.setPositionInModule((ItemStack)stack, (ResourceKey)world.dimension(), (BlockPos)pos, (String)name);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Console module is set to block");
            }
        } else {
            data = data.withCoordinate(BlockPosTools.INVALID);
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Console module is cleared");
            }
        }
        stack.set((DataComponentType)VariousModule.CONSOLE_MODULE_DATA.get(), (Object)data);
        return InteractionResult.SUCCESS;
    }
}

