/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.multitank.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.modules.multitank.MultiTankModule;
import mcjty.rftoolscontrol.modules.multitank.data.MultiTankData;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankFluidProperties;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class MultiTankTileEntity
extends GenericTileEntity {
    public static final int TANKS = 4;
    public static final int MAXCAPACITY = 10000;
    private final MultiTankFluidProperties[] properties = new MultiTankFluidProperties[4];
    private final MultiTankHandler fluidHandler = this.createFluidHandler();
    @Cap(type=CapType.FLUIDS)
    private static final Function<MultiTankTileEntity, MultiTankHandler> FLUID_CAP = tile -> tile.fluidHandler;
    @Cap(type=CapType.CONTAINER)
    private static final Function<MultiTankTileEntity, MenuProvider> SCREEN_CAP = tile -> new DefaultContainerProvider("Multi tank").containerSupplier(DefaultContainerProvider.empty(MultiTankModule.MULTITANK_CONTAINER, (GenericTileEntity)tile)).setupSync((GenericTileEntity)tile);
    @ServerCommand(type=FluidStack.class)
    public static final ListCommand<?, ?> CMD_GETFLUIDS = ListCommand.create((String)"rftoolscontrol.tank.getFluids", (te, player, params) -> {
        ArrayList<FluidStack> result = new ArrayList<FluidStack>(4);
        for (MultiTankFluidProperties property : te.properties) {
            result.add(property.getContents());
        }
        return result;
    }, (te, player, params, list) -> {
        for (int i = 0; i < 4; ++i) {
            te.properties[i].set((FluidStack)list.get(i));
        }
    });

    public MultiTankTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MultiTankModule.MULTITANK.be().get(), pos, state);
        for (int i = 0; i < 4; ++i) {
            this.properties[i] = new MultiTankFluidProperties(this, FluidStack.EMPTY, 10000);
        }
        this.updateTankDataFromProperties();
    }

    public MultiTankFluidProperties[] getProperties() {
        return this.properties;
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.readFluids(tagCompound, provider);
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        this.writeFluids(tagCompound, provider);
    }

    private void readFluids(CompoundTag tagCompound, HolderLookup.Provider provider) {
        ListTag list = tagCompound.getList("fluids", 10);
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>(4);
        for (int i = 0; i < 4; ++i) {
            CompoundTag fluidTag = i < list.size() ? list.getCompound(i) : (tagCompound.contains("tank" + i, 10) ? tagCompound.getCompound("tank" + i) : new CompoundTag());
            FluidStack stack = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)fluidTag);
            this.properties[i].loadFromData(stack);
            fluids.add(stack);
        }
        this.setData(MultiTankModule.MULTITANK_DATA, MultiTankData.of(fluids));
    }

    private void writeFluids(CompoundTag tagCompound, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (int i = 0; i < 4; ++i) {
            CompoundTag fluidTag = new CompoundTag();
            FluidStack stack = this.properties[i].getContentsInternal();
            if (!stack.isEmpty()) {
                stack.save(provider, (Tag)fluidTag);
            }
            list.add((Object)fluidTag);
        }
        tagCompound.put("fluids", (Tag)list);
    }

    @Nonnull
    private MultiTankHandler createFluidHandler() {
        return new MultiTankHandler(this);
    }

    public void onTankContentsChanged() {
        this.updateTankDataFromProperties();
        this.setChanged();
    }

    private void updateTankDataFromProperties() {
        if (this.level != null && this.level.isClientSide) {
            return;
        }
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>(4);
        for (MultiTankFluidProperties property : this.properties) {
            fluids.add(property.getContents());
        }
        this.setData(MultiTankModule.MULTITANK_DATA, MultiTankData.of(fluids));
    }

    private void applyTankData(MultiTankData data) {
        List<FluidStack> fluids = data.fluids();
        for (int i = 0; i < 4; ++i) {
            FluidStack stack = i < fluids.size() ? fluids.get(i) : FluidStack.EMPTY;
            this.properties[i].loadFromData(stack);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        MultiTankData data = (MultiTankData)input.get(MultiTankModule.ITEM_MULTITANK_DATA);
        if (data != null) {
            this.setData(MultiTankModule.MULTITANK_DATA, data);
            this.applyTankData(data);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MultiTankModule.ITEM_MULTITANK_DATA, (Object)((MultiTankData)this.getData(MultiTankModule.MULTITANK_DATA)));
    }
}

