/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.trueuuid.command;

import cn.alini.trueuuid.server.NameRegistry;
import cn.alini.trueuuid.server.TrueuuidRuntime;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trueuuid")
public class TrueuuidCommands {
    @SubscribeEvent
    public static void onRegister(RegisterCommandsEvent e) {
        CommandDispatcher d = e.getDispatcher();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trueuuid").requires(src -> src.m_6761_(3))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"link").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> TrueuuidCommands.run((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), true, true, true, true, true)))).then(Commands.m_82127_((String)"run").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> TrueuuidCommands.run((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), false, true, true, true, true))))).then(Commands.m_82127_((String)"dryrun").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> TrueuuidCommands.run((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), true, true, true, true, true))))));
    }

    private static int run(CommandSourceStack src, String name, boolean dryRun, boolean backup, boolean mergeInv, boolean mergeEnder, boolean mergeStats) {
        MinecraftServer server = src.m_81377_();
        Optional<NameRegistry.Entry> reg = TrueuuidCommands.getEntry(name);
        if (reg.isEmpty()) {
            src.m_81352_((Component)Component.m_237113_((String)("\u672a\u5728\u6ce8\u518c\u8868\u4e2d\u627e\u5230\u8be5\u540d\u5b57\u7684\u6b63\u7248\u8bb0\u5f55\uff1a" + name)));
            return 0;
        }
        UUID premium = reg.get().premiumUuid;
        UUID offline = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
        Path worldRoot = server.m_129843_(LevelResource.f_78182_);
        Path playerData = server.m_129843_(LevelResource.f_78176_);
        Path adv = worldRoot.resolve("advancements");
        Path stats = worldRoot.resolve("stats");
        Path premDat = playerData.resolve(premium + ".dat");
        Path offDat = playerData.resolve(offline + ".dat");
        Path premAdv = adv.resolve(premium + ".json");
        Path offAdv = adv.resolve(offline + ".json");
        Path premStats = stats.resolve(premium + ".json");
        Path offStats = stats.resolve(offline + ".json");
        src.m_288197_(() -> Component.m_237113_((String)("[TrueUUID] link " + (dryRun ? "(dry-run)" : "(run)") + " name=" + name + "\n premium=" + premium + "\n offline=" + offline + "\n files:\n  " + offDat + " -> " + premDat + "\n  " + offAdv + " -> " + premAdv + "\n  " + offStats + " -> " + premStats)), false);
        if (dryRun) {
            return 1;
        }
        try {
            if (backup) {
                String ts = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss").format(LocalDateTime.now());
                Path backupDir = worldRoot.resolve("backups/trueuuid/" + ts + "/" + name.toLowerCase(Locale.ROOT));
                Files.createDirectories(backupDir, new FileAttribute[0]);
                TrueuuidCommands.copyIfExists(premDat, backupDir.resolve("premium.dat"));
                TrueuuidCommands.copyIfExists(offDat, backupDir.resolve("offline.dat"));
                TrueuuidCommands.copyIfExists(premAdv, backupDir.resolve("premium.adv.json"));
                TrueuuidCommands.copyIfExists(offAdv, backupDir.resolve("offline.adv.json"));
                TrueuuidCommands.copyIfExists(premStats, backupDir.resolve("premium.stats.json"));
                TrueuuidCommands.copyIfExists(offStats, backupDir.resolve("offline.stats.json"));
            }
            if (Files.exists(offDat, new LinkOption[0])) {
                if (!Files.exists(premDat, new LinkOption[0])) {
                    Files.move(offDat, premDat, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    TrueuuidCommands.mergePlayerDatNBT(premDat, offDat, mergeInv, mergeEnder);
                }
            }
            if (Files.exists(offAdv, new LinkOption[0])) {
                if (!Files.exists(premAdv, new LinkOption[0])) {
                    Files.move(offAdv, premAdv, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    TrueuuidCommands.mergeAdvancementsJson(premAdv, offAdv);
                }
            }
            if (Files.exists(offStats, new LinkOption[0])) {
                if (!Files.exists(premStats, new LinkOption[0])) {
                    Files.move(offStats, premStats, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    TrueuuidCommands.mergeStatsJson(premStats, offStats);
                }
            }
            src.m_288197_(() -> Component.m_237113_((String)"\u5b8c\u6210\u3002\u5efa\u8bae\u73a9\u5bb6\u4e0b\u6b21\u4ee5\u6b63\u7248\u767b\u5f55\u786e\u8ba4\u6570\u636e\u3002"), false);
            return 1;
        }
        catch (Exception ex) {
            src.m_81352_((Component)Component.m_237113_((String)("\u5931\u8d25\uff1a" + ex.getMessage())));
            ex.printStackTrace();
            return 0;
        }
    }

    private static Optional<NameRegistry.Entry> getEntry(String name) {
        try {
            Field f = NameRegistry.class.getDeclaredField("map");
            f.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return TrueuuidRuntime.NAME_REGISTRY.getPremiumUuid(name).map(u -> {
            NameRegistry.Entry e = new NameRegistry.Entry();
            e.premiumUuid = u;
            return e;
        });
    }

    private static void copyIfExists(Path from, Path to) throws Exception {
        if (Files.exists(from, new LinkOption[0])) {
            Files.createDirectories(to.getParent(), new FileAttribute[0]);
            Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void mergePlayerDatNBT(Path premDat, Path offDat, boolean mergeInv, boolean mergeEnder) throws Exception {
        CompoundTag off;
        CompoundTag prem;
        try (InputStream is = Files.newInputStream(premDat, new OpenOption[0]);){
            prem = NbtIo.m_128939_((InputStream)is);
        }
        is = Files.newInputStream(offDat, new OpenOption[0]);
        try {
            off = NbtIo.m_128939_((InputStream)is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        boolean changed = false;
        if (mergeInv) {
            changed |= TrueuuidCommands.mergeItemListTag(prem, off, "Inventory");
        }
        if (mergeEnder) {
            changed |= TrueuuidCommands.mergeItemListTag(prem, off, "EnderItems");
        }
        if (changed) {
            try (OutputStream os = Files.newOutputStream(premDat, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                NbtIo.m_128947_((CompoundTag)prem, (OutputStream)os);
            }
        }
    }

    private static boolean mergeItemListTag(CompoundTag prem, CompoundTag off, String key) {
        if (!prem.m_128441_(key) || !off.m_128441_(key)) {
            return false;
        }
        ListTag premList = prem.m_128437_(key, 10);
        ListTag offList = off.m_128437_(key, 10);
        HashSet<Integer> premSlots = new HashSet<Integer>();
        for (int i = 0; i < premList.size(); ++i) {
            CompoundTag tag = premList.m_128728_(i);
            if (!tag.m_128441_("Slot")) continue;
            premSlots.add(Integer.valueOf(tag.m_128445_("Slot")));
        }
        boolean changed = false;
        for (int i = 0; i < offList.size(); ++i) {
            byte slot;
            CompoundTag tag = offList.m_128728_(i);
            if (!tag.m_128441_("Slot") || premSlots.contains(slot = tag.m_128445_("Slot"))) continue;
            premList.add((Object)tag.m_6426_());
            changed = true;
        }
        if (changed) {
            prem.m_128365_(key, (Tag)premList);
        }
        return changed;
    }

    private static void mergeAdvancementsJson(Path premAdv, Path offAdv) throws Exception {
        JsonObject off;
        JsonObject prem;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedReader r = Files.newBufferedReader(premAdv);){
            prem = (JsonObject)gson.fromJson((Reader)r, JsonObject.class);
        }
        r = Files.newBufferedReader(offAdv);
        try {
            off = (JsonObject)gson.fromJson((Reader)r, JsonObject.class);
        }
        finally {
            if (r != null) {
                ((Reader)r).close();
            }
        }
        boolean changed = false;
        for (String key : off.keySet()) {
            if (prem.has(key)) continue;
            prem.add(key, off.get(key));
            changed = true;
        }
        if (changed) {
            try (BufferedWriter w = Files.newBufferedWriter(premAdv, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
                gson.toJson((JsonElement)prem, (Appendable)w);
            }
        }
    }

    private static void mergeStatsJson(Path premStats, Path offStats) throws Exception {
        JsonObject off;
        JsonObject prem;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedReader r = Files.newBufferedReader(premStats);){
            prem = (JsonObject)gson.fromJson((Reader)r, JsonObject.class);
        }
        r = Files.newBufferedReader(offStats);
        try {
            off = (JsonObject)gson.fromJson((Reader)r, JsonObject.class);
        }
        finally {
            if (r != null) {
                ((Reader)r).close();
            }
        }
        boolean changed = false;
        for (String cat : off.keySet()) {
            JsonObject offCat = off.getAsJsonObject(cat);
            JsonObject premCat = prem.has(cat) ? prem.getAsJsonObject(cat) : new JsonObject();
            for (String key : offCat.keySet()) {
                if (!premCat.has(key)) {
                    premCat.add(key, offCat.get(key));
                    changed = true;
                    continue;
                }
                try {
                    long a = premCat.get(key).getAsLong();
                    long b = offCat.get(key).getAsLong();
                    long sum = a + b;
                    premCat.addProperty(key, (Number)sum);
                    changed = true;
                }
                catch (Exception exception) {}
            }
            prem.add(cat, (JsonElement)premCat);
        }
        if (changed) {
            try (BufferedWriter w = Files.newBufferedWriter(premStats, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
                gson.toJson((JsonElement)prem, (Appendable)w);
            }
        }
    }
}

