/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.trueuuid.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public final class TrueuuidConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
    }

    public static long timeoutMs() {
        return (Long)TrueuuidConfig.COMMON.timeoutMs.get();
    }

    public static boolean allowOfflineOnTimeout() {
        return (Boolean)TrueuuidConfig.COMMON.allowOfflineOnTimeout.get();
    }

    public static boolean allowOfflineOnFailure() {
        return (Boolean)TrueuuidConfig.COMMON.allowOfflineOnFailure.get();
    }

    public static String timeoutKickMessage() {
        return (String)TrueuuidConfig.COMMON.timeoutKickMessage.get();
    }

    public static String offlineFallbackMessage() {
        return (String)TrueuuidConfig.COMMON.offlineFallbackMessage.get();
    }

    public static String offlineShortSubtitle() {
        return (String)TrueuuidConfig.COMMON.offlineShortSubtitle.get();
    }

    public static String onlineShortSubtitle() {
        return (String)TrueuuidConfig.COMMON.onlineShortSubtitle.get();
    }

    public static boolean knownPremiumDenyOffline() {
        return (Boolean)TrueuuidConfig.COMMON.knownPremiumDenyOffline.get();
    }

    public static boolean allowOfflineForUnknownOnly() {
        return (Boolean)TrueuuidConfig.COMMON.allowOfflineForUnknownOnly.get();
    }

    public static boolean recentIpGraceEnabled() {
        return (Boolean)TrueuuidConfig.COMMON.recentIpGraceEnabled.get();
    }

    public static int recentIpGraceTtlSeconds() {
        return (Integer)TrueuuidConfig.COMMON.recentIpGraceTtlSeconds.get();
    }

    private TrueuuidConfig() {
    }

    static {
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        COMMON = new Common(b);
        COMMON_SPEC = b.build();
    }

    public static final class Common {
        public final ForgeConfigSpec.LongValue timeoutMs;
        public final ForgeConfigSpec.BooleanValue allowOfflineOnTimeout;
        public final ForgeConfigSpec.BooleanValue allowOfflineOnFailure;
        public final ForgeConfigSpec.ConfigValue<String> timeoutKickMessage;
        public final ForgeConfigSpec.ConfigValue<String> offlineFallbackMessage;
        public final ForgeConfigSpec.ConfigValue<String> offlineShortSubtitle;
        public final ForgeConfigSpec.ConfigValue<String> onlineShortSubtitle;
        public final ForgeConfigSpec.BooleanValue knownPremiumDenyOffline;
        public final ForgeConfigSpec.BooleanValue allowOfflineForUnknownOnly;
        public final ForgeConfigSpec.BooleanValue recentIpGraceEnabled;
        public final ForgeConfigSpec.IntValue recentIpGraceTtlSeconds;

        Common(ForgeConfigSpec.Builder b) {
            b.push("auth");
            this.timeoutMs = b.defineInRange("timeoutMs", 10000L, 1000L, 600000L);
            this.allowOfflineOnTimeout = b.comment("false:\u8d85\u65f6\u8e22\u51fa(\u9ed8\u8ba4)true:\u8d85\u65f6\u653e\u884c\u4e3a\u79bb\u7ebf").define("allowOfflineOnTimeout", false);
            this.allowOfflineOnFailure = b.comment("false:\u5931\u8d25\u65f6\u8e22\u51fatrue:\u4efb\u4f55\u9274\u6743\u5931\u8d25\u653e\u884c\u4e3a\u79bb\u7ebf(\u9ed8\u8ba4)").define("allowOfflineOnFailure", true);
            this.timeoutKickMessage = b.define("timeoutKickMessage", (Object)"\u767b\u5f55\u8d85\u65f6\uff0c\u672a\u5b8c\u6210\u8d26\u53f7\u6821\u9a8c");
            this.offlineFallbackMessage = b.define("offlineFallbackMessage", (Object)"\u6ce8\u610f\uff1a\u4f60\u5f53\u524d\u4ee5\u79bb\u7ebf\u6a21\u5f0f\u8fdb\u5165\u670d\u52a1\u5668\uff1b\u5982\u679c\u4f60\u662f\u6b63\u7248\u8d26\u53f7\uff0c\u53ef\u80fd\u662f\u7f51\u7edc\u539f\u56e0\u5bfc\u81f4\u65e0\u6cd5\u6210\u529f\u9274\u6743\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\u91cd\u8bd5\u3002\u7ee7\u7eed\u6e38\u73a9\uff0c\u82e5\u540e\u7eed\u9274\u6743\u6210\u529f\u53ef\u80fd\u4f1a\u4e22\u5931\u73a9\u5bb6\u6570\u636e\u3002");
            this.offlineShortSubtitle = b.define("offlineShortSubtitle", (Object)"\u9274\u6743\u5931\u8d25\uff1a\u79bb\u7ebf\u6a21\u5f0f");
            this.onlineShortSubtitle = b.define("onlineShortSubtitle", (Object)"\u5df2\u901a\u8fc7\u6b63\u7248\u6821\u9a8c");
            this.knownPremiumDenyOffline = b.comment("\u4e00\u65e6\u8be5\u540d\u5b57\u6210\u529f\u9a8c\u8bc1\u8fc7\u6b63\u7248\uff0c\u540e\u7eed\u9274\u6743\u5931\u8d25\u65f6\u7981\u6b62\u4ee5\u79bb\u7ebf\u8eab\u4efd\u8fdb\u5165\u3002").define("knownPremiumDenyOffline", true);
            this.allowOfflineForUnknownOnly = b.comment("\u4ec5\u5bf9\u4ece\u672a\u9a8c\u8bc1\u4e3a\u6b63\u7248\u7684\u65b0\u540d\u5b57\u5141\u8bb8\u79bb\u7ebf\u515c\u5e95\u3002").define("allowOfflineForUnknownOnly", true);
            this.recentIpGraceEnabled = b.comment("\u542f\u7528\u201c\u8fd1\u671f\u540c IP \u6210\u529f\u201d\u5bb9\u9519\uff0c\u5728 TTL \u5185\u5931\u8d25\u65f6\u4e34\u65f6\u6309\u6b63\u7248\u5904\u7406\u3002").define("recentIpGrace.enabled", true);
            this.recentIpGraceTtlSeconds = b.comment("\u201c\u8fd1\u671f\u540c IP \u6210\u529f\u201d\u5bb9\u9519\u7684 TTL \u79d2\u6570\u3002\u5efa\u8bae 60~600\u3002").defineInRange("recentIpGrace.ttlSeconds", 300, 30, 3600);
            b.pop();
        }
    }
}

