/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.trueuuid.mixin.server;

import cn.alini.trueuuid.config.TrueuuidConfig;
import cn.alini.trueuuid.net.NetIds;
import cn.alini.trueuuid.server.AuthDecider;
import cn.alini.trueuuid.server.AuthState;
import cn.alini.trueuuid.server.SessionCheck;
import cn.alini.trueuuid.server.TrueuuidRuntime;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import io.netty.buffer.Unpooled;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net.minecraft.server.network.ServerLoginPacketListenerImpl"})
public abstract class ServerLoginMixin {
    @Shadow
    private GameProfile f_10021_;
    @Shadow
    private MinecraftServer f_10018_;
    @Shadow
    private Connection f_10013_;
    @Unique
    private static final AtomicInteger TRUEUUID$NEXT_TX_ID = new AtomicInteger(1);
    @Unique
    private int trueuuid$txId = 0;
    @Unique
    private String trueuuid$nonce = null;
    @Unique
    private long trueuuid$sentAt = 0L;

    @Shadow
    public abstract void m_10053_(Component var1);

    @Inject(method={"handleHello"}, at={@At(value="TAIL")})
    private void trueuuid$afterHello(ServerboundHelloPacket pkt, CallbackInfo ci) {
        if (this.f_10018_.m_129797_() || this.f_10021_ == null) {
            return;
        }
        this.trueuuid$nonce = UUID.randomUUID().toString().replace("-", "");
        this.trueuuid$txId = TRUEUUID$NEXT_TX_ID.getAndIncrement();
        this.trueuuid$sentAt = System.currentTimeMillis();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(this.trueuuid$nonce);
        this.f_10013_.m_129512_((Packet)new ClientboundCustomQueryPacket(this.trueuuid$txId, NetIds.AUTH, buf));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void trueuuid$onTick(CallbackInfo ci) {
        if (this.trueuuid$txId == 0 || this.trueuuid$sentAt == 0L) {
            return;
        }
        long timeoutMs = TrueuuidConfig.timeoutMs();
        if (timeoutMs <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.trueuuid$sentAt < timeoutMs) {
            return;
        }
        if (TrueuuidConfig.allowOfflineOnTimeout()) {
            AuthState.markOfflineFallback(this.f_10013_, AuthState.FallbackReason.TIMEOUT);
            this.reset();
        } else {
            String msg = TrueuuidConfig.timeoutKickMessage();
            MutableComponent reason = Component.m_237113_((String)(msg != null ? msg : "\u767b\u5f55\u8d85\u65f6\uff0c\u672a\u5b8c\u6210\u8d26\u53f7\u6821\u9a8c"));
            this.sendDisconnectWithReason((Component)reason);
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"handleCustomQueryPacket"}, at={@At(value="HEAD")}, cancellable=true)
    private void trueuuid$onLoginCustom(ServerboundCustomQueryPacket packet, CallbackInfo ci) {
        FriendlyByteBuf data;
        if (this.trueuuid$txId == 0) {
            return;
        }
        if (packet.m_179824_() != this.trueuuid$txId) {
            return;
        }
        String ip = null;
        SocketAddress socketAddress = this.f_10013_.m_129523_();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            ip = isa.getAddress().getHostAddress();
        }
        if ((data = packet.m_179825_()) == null) {
            this.handleAuthFailure(ip, "\u7f3a\u5c11\u6570\u636e");
            this.reset();
            ci.cancel();
            return;
        }
        boolean ackOk = false;
        try {
            ackOk = data.readBoolean();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!ackOk) {
            this.handleAuthFailure(ip, "\u5ba2\u6237\u7aef\u62d2\u7edd");
            this.reset();
            ci.cancel();
            return;
        }
        try {
            Optional<SessionCheck.HasJoinedResult> resOpt = SessionCheck.hasJoined(this.f_10021_.getName(), this.trueuuid$nonce, ip);
            if (resOpt.isEmpty()) {
                this.handleAuthFailure(ip, "\u4f1a\u8bdd\u65e0\u6548");
                this.reset();
                ci.cancel();
                return;
            }
            SessionCheck.HasJoinedResult res = resOpt.get();
            TrueuuidRuntime.NAME_REGISTRY.recordSuccess(res.name(), res.uuid(), ip);
            TrueuuidRuntime.IP_GRACE.record(res.name(), ip, res.uuid());
            GameProfile newProfile = new GameProfile(res.uuid(), res.name());
            PropertyMap propMap = newProfile.getProperties();
            propMap.removeAll((Object)"textures");
            for (SessionCheck.Property p : res.properties()) {
                if (p.signature() != null) {
                    propMap.put((Object)p.name(), (Object)new Property(p.name(), p.value(), p.signature()));
                    continue;
                }
                propMap.put((Object)p.name(), (Object)new Property(p.name(), p.value()));
            }
            this.f_10021_ = newProfile;
        }
        catch (Throwable t) {
            this.handleAuthFailure(ip, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
        finally {
            this.reset();
            ci.cancel();
        }
    }

    @Unique
    private void handleAuthFailure(String ip, String why) {
        String name = this.f_10021_ != null ? this.f_10021_.getName() : "<unknown>";
        AuthDecider.Decision d = AuthDecider.onFailure(name, ip);
        switch (d.kind) {
            case PREMIUM_GRACE: {
                UUID premium;
                UUID uUID = premium = d.premiumUuid != null ? d.premiumUuid : (UUID)TrueuuidRuntime.NAME_REGISTRY.getPremiumUuid(name).orElse(null);
                if (premium != null) {
                    this.f_10021_ = new GameProfile(premium, name);
                    break;
                }
                AuthState.markOfflineFallback(this.f_10013_, AuthState.FallbackReason.FAILURE);
                break;
            }
            case OFFLINE: {
                AuthState.markOfflineFallback(this.f_10013_, AuthState.FallbackReason.FAILURE);
                break;
            }
            case DENY: {
                String msg = d.denyMessage != null ? d.denyMessage : "\u9274\u6743\u5931\u8d25\uff0c\u5df2\u7981\u6b62\u79bb\u7ebf\u8fdb\u5165\u4ee5\u4fdd\u62a4\u4f60\u7684\u6b63\u7248\u5b58\u6863\u3002\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002";
                this.sendDisconnectWithReason((Component)Component.m_237113_((String)msg));
            }
        }
    }

    @Unique
    private void sendDisconnectWithReason(Component reason) {
        try {
            this.f_10013_.m_129512_((Packet)new ClientboundLoginDisconnectPacket(reason));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.f_10013_.m_129512_((Packet)new ClientboundDisconnectPacket(reason));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.f_10013_.m_129507_(reason);
    }

    @Unique
    private void reset() {
        this.trueuuid$txId = 0;
        this.trueuuid$nonce = null;
        this.trueuuid$sentAt = 0L;
    }
}

