/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.trueuuid.server;

import cn.alini.trueuuid.config.TrueuuidConfig;
import cn.alini.trueuuid.server.AuthState;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trueuuid")
public class SkinRefreshHandler {
    private static final int SUBTITLE_MAX_CHARS = 64;

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        MinecraftServer server = sp.m_20194_();
        if (server == null) {
            return;
        }
        server.execute(() -> {
            PlayerList list = server.m_6846_();
            list.m_11268_((Packet)new ClientboundPlayerInfoRemovePacket(List.of(sp.m_20148_())));
            list.m_11268_((Packet)ClientboundPlayerInfoUpdatePacket.m_247122_(List.of(sp)));
        });
        Connection netConn = sp.f_8906_.f_9742_;
        Optional<AuthState.FallbackReason> fallbackOpt = AuthState.consume(netConn);
        if (fallbackOpt.isPresent()) {
            String longMsg = TrueuuidConfig.offlineFallbackMessage();
            if (longMsg == null || longMsg.isEmpty()) {
                longMsg = "\u6ce8\u610f\uff1a\u4f60\u5f53\u524d\u4ee5\u79bb\u7ebf\u6a21\u5f0f\u8fdb\u5165\u670d\u52a1\u5668\uff1b\u5982\u679c\u4f60\u662f\u6b63\u7248\u8d26\u53f7\uff0c\u53ef\u80fd\u662f\u7f51\u7edc\u539f\u56e0\u5bfc\u81f4\u65e0\u6cd5\u6210\u529f\u9274\u6743\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\u91cd\u8bd5\u3002";
            }
            sp.m_213846_((Component)Component.m_237113_((String)longMsg).m_130940_(ChatFormatting.RED));
            MutableComponent title = Component.m_237113_((String)"\u79bb\u7ebf\u6a21\u5f0f").m_130940_(ChatFormatting.RED);
            String shortSubtitle = TrueuuidConfig.offlineShortSubtitle();
            MutableComponent subtitle = Component.m_237113_((String)SkinRefreshHandler.clamp(shortSubtitle, 64)).m_130940_(ChatFormatting.YELLOW);
            sp.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 60, 10));
            sp.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)title));
            sp.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)subtitle));
        } else {
            MutableComponent title = Component.m_237113_((String)"\u6b63\u7248\u6a21\u5f0f").m_130940_(ChatFormatting.GREEN);
            String shortSubtitle = TrueuuidConfig.onlineShortSubtitle();
            MutableComponent subtitle = Component.m_237113_((String)SkinRefreshHandler.clamp(shortSubtitle, 64)).m_130940_(ChatFormatting.GRAY);
            sp.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 60, 10));
            sp.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)title));
            sp.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)subtitle));
        }
    }

    private static String clamp(String s, int max) {
        if (s == null) {
            return "";
        }
        if (s.length() <= max) {
            return s;
        }
        return s.substring(0, Math.max(0, max - 1)) + "\u2026";
    }
}

