/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.offlineauth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public class AuthConfig {
    private static final Path BASE_DIR = FMLPaths.CONFIGDIR.get().resolve("offlineauth");
    private static final Path FILE_PATH = BASE_DIR.resolve("config.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static AuthConfig INSTANCE;
    public int timeoutSeconds = 60;
    public int autoLoginExpireSeconds = 600;
    public int maxFailAttempts = 5;
    public int failLockSeconds = 60;
    public boolean autoLoginEnable = true;
    public boolean failBlockEnable = true;
    public String prefix = "\u00a77[\u00a7bAuth\u00a77] ";
    public Map<String, String> messages = new HashMap<String, String>();

    private AuthConfig() {
        this.messages.put("register_prompt", "\u00a7c\u9996\u6b21\u8fdb\u670d\uff0c\u8bf7\u4f7f\u7528 /register \u5bc6\u7801 \u786e\u8ba4\u5bc6\u7801 \u6ce8\u518c\u8d26\u6237\uff01");
        this.messages.put("login_prompt", "\u00a7e\u8bf7\u4f7f\u7528 /login \u5bc6\u7801 \u767b\u5f55\u8d26\u6237\uff01");
        this.messages.put("already_registered", "\u00a7c\u60a8\u5df2\u6ce8\u518c\uff0c\u8bf7\u7528 /login \u5bc6\u7801 \u767b\u5f55\uff01");
        this.messages.put("not_registered", "\u00a7c\u60a8\u5c1a\u672a\u6ce8\u518c\uff0c\u8bf7\u7528 /register \u5bc6\u7801 \u786e\u8ba4\u5bc6\u7801 \u6ce8\u518c\uff01");
        this.messages.put("register_success", "\u00a7a\u6ce8\u518c\u6210\u529f\uff0c\u5df2\u81ea\u52a8\u767b\u5165\uff01");
        this.messages.put("login_success", "\u00a7a\u767b\u5f55\u6210\u529f\uff01");
        this.messages.put("auto_login_success", "\u00a7a\u68c0\u6d4b\u5230\u540cIP\u8bbe\u5907\uff0c\u5df2\u81ea\u52a8\u767b\u5f55\u3002");
        this.messages.put("password_mismatch", "\u00a7c\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01");
        this.messages.put("wrong_password", "\u00a7c\u5bc6\u7801\u9519\u8bef\uff01");
        this.messages.put("timeout", "\u00a7c\u672a\u767b\u5f55\u8d85\u65f6\u5df2\u88ab\u8e22\u51fa\uff01");
        this.messages.put("no_permission_register", "\u00a7c\u6b63\u7248\u73a9\u5bb6\u65e0\u9700\u6ce8\u518c\uff01");
        this.messages.put("no_permission_login", "\u00a7c\u6b63\u7248\u73a9\u5bb6\u65e0\u9700\u767b\u5f55\uff01");
        this.messages.put("no_permission_changepwd", "\u00a7c\u6b63\u7248\u73a9\u5bb6\u65e0\u9700\u4fee\u6539\u5bc6\u7801\uff01");
        this.messages.put("changepwd_success", "\u00a7a\u5bc6\u7801\u4fee\u6539\u6210\u529f\uff01");
        this.messages.put("changepwd_wrong", "\u00a7c\u539f\u5bc6\u7801\u9519\u8bef\uff01");
        this.messages.put("inventory_restored", "\u00a7a\u80cc\u5305\u5df2\u6062\u590d");
        this.messages.put("chat_blocked", "\u00a7c\u672a\u767b\u5f55\u7981\u6b62\u53d1\u8a00");
        this.messages.put("break_blocked", "\u00a7c\u672a\u767b\u5f55\u7981\u6b62\u7834\u574f\u65b9\u5757");
        this.messages.put("place_blocked", "\u00a7c\u672a\u767b\u5f55\u7981\u6b62\u653e\u7f6e\u65b9\u5757");
        this.messages.put("drop_blocked", "\u00a7c\u672a\u767b\u5f55\u7981\u6b62\u4e22\u5f03\u7269\u54c1");
        this.messages.put("pickup_blocked", "\u00a7c\u672a\u767b\u5f55\u7981\u6b62\u62fe\u53d6\u7269\u54c1");
        this.messages.put("use_blocked", "\u00a7c\u672a\u767b\u5f55\u7981\u6b62\u4f7f\u7528\u7269\u54c1");
        this.messages.put("container_blocked", "\u00a7c\u672a\u767b\u5f55\u7981\u6b62\u6253\u5f00\u80cc\u5305/\u5bb9\u5668");
        this.messages.put("fail_blocked", "\u00a7c\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7{lock}\u79d2\u540e\u518d\u8bd5\uff01");
        this.messages.put("fail_attempts_left", "\u00a7c\u5bc6\u7801\u9519\u8bef\uff01\u5269\u4f59\u5c1d\u8bd5\u6b21\u6570\uff1a{left}");
        this.messages.put("help_header", "\u00a76\u79bb\u7ebf\u8ba4\u8bc1\u63d2\u4ef6\u6307\u4ee4\u5217\u8868\uff1a");
        this.messages.put("help_register", "\u00a7e/register \u5bc6\u7801 \u786e\u8ba4\u5bc6\u7801 \u00a77- \u6ce8\u518c\u8d26\u6237\uff08\u9996\u6b21\u8fdb\u670d\u4f7f\u7528\uff09");
        this.messages.put("help_login", "\u00a7e/login \u5bc6\u7801 \u00a77- \u767b\u5f55\u8d26\u6237");
        this.messages.put("help_changepwd", "\u00a7e/changepassword \u65e7\u5bc6\u7801 \u65b0\u5bc6\u7801 \u00a77- \u4fee\u6539\u5bc6\u7801");
        this.messages.put("auto_login_warn", "\u00a7e\u26a0\u5df2\u542f\u7528\u81ea\u52a8\u767b\u5f55\uff08\u540cIP\u8bbe\u5907\u77ed\u65f6\u95f4\u5185\u65e0\u9700\u91cd\u590d\u767b\u5f55\uff09\u3002\u5982\u5728\u7f51\u5427/\u516c\u5171\u7535\u8111\u8bf7\u52ff\u4f7f\u7528\u6b64\u529f\u80fd\uff0c\u907f\u514d\u8d26\u53f7\u88ab\u76d7\u3002");
    }

    public static synchronized AuthConfig loadConfig() {
        if (INSTANCE == null) {
            INSTANCE = new AuthConfig();
        }
        INSTANCE.loadFromDisk();
        return INSTANCE;
    }

    public static synchronized AuthConfig getInstance() {
        if (INSTANCE == null) {
            AuthConfig.loadConfig();
        }
        return INSTANCE;
    }

    private void loadFromDisk() {
        try {
            if (!Files.exists(BASE_DIR, new LinkOption[0])) {
                Files.createDirectories(BASE_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = FILE_PATH.toFile();
        if (!file.exists()) {
            this.saveToDisk();
            return;
        }
        try (FileReader reader = new FileReader(file);){
            AuthConfig loaded = (AuthConfig)gson.fromJson((Reader)reader, AuthConfig.class);
            if (loaded != null) {
                this.timeoutSeconds = loaded.timeoutSeconds;
                this.autoLoginExpireSeconds = loaded.autoLoginExpireSeconds;
                this.maxFailAttempts = loaded.maxFailAttempts;
                this.failLockSeconds = loaded.failLockSeconds;
                this.autoLoginEnable = loaded.autoLoginEnable;
                this.failBlockEnable = loaded.failBlockEnable;
                this.prefix = loaded.prefix;
                if (loaded.messages != null) {
                    this.messages.putAll(loaded.messages);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToDisk() {
        try {
            if (!Files.exists(BASE_DIR, new LinkOption[0])) {
                Files.createDirectories(BASE_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (FileWriter writer = new FileWriter(FILE_PATH.toFile());){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String msg(String key) {
        return this.prefix + this.messages.getOrDefault(key, "\u914d\u7f6e\u7f3a\u5931\uff1a" + key);
    }

    public String msg(String key, Map<String, String> params) {
        Object raw = this.prefix + this.messages.getOrDefault(key, "\u914d\u7f6e\u7f3a\u5931\uff1a" + key);
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                raw = ((String)raw).replace("{" + e.getKey() + "}", e.getValue());
            }
        }
        return raw;
    }

    public static String getConfigFilePathForDebug() {
        return FILE_PATH.toAbsolutePath().toString();
    }
}

