/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.offlineauth;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public class JsonAuthStorage {
    private static final Path BASE_DIR = FMLPaths.CONFIGDIR.get().resolve("offlineauth");
    private static final Path FILE_PATH = BASE_DIR.resolve("auth.json");
    private static final Gson gson = new Gson();
    private static JsonAuthStorage INSTANCE;
    private Map<String, String> credentials = new HashMap<String, String>();
    private long lastModified = -1L;

    private JsonAuthStorage() {
        this.loadFromDisk();
    }

    public static synchronized JsonAuthStorage getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JsonAuthStorage();
        }
        return INSTANCE;
    }

    private synchronized void reloadIfChanged() {
        File file = FILE_PATH.toFile();
        if (!file.exists()) {
            this.credentials = new HashMap<String, String>();
            this.lastModified = -1L;
            return;
        }
        long lm = file.lastModified();
        if (lm != this.lastModified) {
            this.loadFromDisk();
        }
    }

    private synchronized void loadFromDisk() {
        this.credentials = new HashMap<String, String>();
        try {
            if (!Files.exists(BASE_DIR, new LinkOption[0])) {
                Files.createDirectories(BASE_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = FILE_PATH.toFile();
        if (!file.exists()) {
            this.saveToDisk();
            this.lastModified = file.exists() ? file.lastModified() : -1L;
            return;
        }
        try (FileReader reader = new FileReader(file);){
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map map = (Map)gson.fromJson((Reader)reader, type);
            if (map != null) {
                this.credentials.putAll(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lastModified = file.lastModified();
    }

    private synchronized void saveToDisk() {
        try {
            if (!Files.exists(BASE_DIR, new LinkOption[0])) {
                Files.createDirectories(BASE_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (FileWriter writer = new FileWriter(FILE_PATH.toFile());){
            gson.toJson(this.credentials, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = FILE_PATH.toFile();
        this.lastModified = file.exists() ? file.lastModified() : -1L;
    }

    public synchronized boolean isRegistered(String name) {
        this.reloadIfChanged();
        return this.credentials.containsKey(name);
    }

    public synchronized void register(String name, String password) {
        this.reloadIfChanged();
        this.credentials.put(name, password);
        this.saveToDisk();
    }

    public synchronized boolean checkPassword(String name, String password) {
        this.reloadIfChanged();
        return this.credentials.containsKey(name) && this.credentials.get(name).equals(password);
    }

    public synchronized void changePassword(String name, String newPassword) {
        this.reloadIfChanged();
        if (this.credentials.containsKey(name)) {
            this.credentials.put(name, newPassword);
            this.saveToDisk();
        }
    }

    public static String getStorageFilePathForDebug() {
        return FILE_PATH.toAbsolutePath().toString();
    }
}

