/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.offlineauth;

import cn.alini.offlineauth.AuthConfig;
import cn.alini.offlineauth.JsonAuthStorage;
import cn.alini.trueuuid.api.TrueuuidApi;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber
public class OfflineAuthHandler {
    private static final JsonAuthStorage storage = JsonAuthStorage.getInstance();
    private static final AuthConfig config = AuthConfig.getInstance();
    private static final Set<String> loggedIn = new HashSet<String>();
    private static final Map<String, ItemStack[]> inventoryBackup = new HashMap<String, ItemStack[]>();
    private static final Map<String, Long> joinTimeMap = new HashMap<String, Long>();
    private static final Map<String, Integer> notLoggedTick = new HashMap<String, Integer>();
    private static final Map<String, double[]> notLoggedSpawnPos = new HashMap<String, double[]>();
    private static final Path BASE_DIR = FMLPaths.CONFIGDIR.get().resolve("offlineauth");
    private static final Path INVENTORY_DIR = BASE_DIR.resolve("inventory");
    private static final Path AUTOLOGIN_PATH = BASE_DIR.resolve("autologin.json");
    private static final Path FAIL_PATH = BASE_DIR.resolve("fail.json");
    private static final Gson gson = new Gson();
    private static final Map<String, AutoLoginInfo> autoLoginMap = new HashMap<String, AutoLoginInfo>();
    private static final Map<String, FailInfo> failMap = new HashMap<String, FailInfo>();

    private static boolean isOfflinePlayer(ServerPlayer player) {
        return !TrueuuidApi.isPremium((String)player.m_7755_().getString().toLowerCase(Locale.ROOT));
    }

    private static String getPlayerIp(ServerPlayer player) {
        int idx;
        ServerGamePacketListenerImpl conn = player.f_8906_;
        String raw = conn.m_264262_().toString();
        if (raw.startsWith("/")) {
            raw = raw.substring(1);
        }
        if ((idx = raw.indexOf(58)) > 0) {
            return raw.substring(0, idx);
        }
        return raw;
    }

    private static void loadAutoLogin() {
        File f = AUTOLOGIN_PATH.toFile();
        if (!f.exists()) {
            return;
        }
        try (FileReader r = new FileReader(f);){
            Type t = new TypeToken<Map<String, AutoLoginInfo>>(){}.getType();
            Map m = (Map)gson.fromJson((Reader)r, t);
            if (m != null) {
                autoLoginMap.putAll(m);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void saveAutoLogin() {
        File f = AUTOLOGIN_PATH.toFile();
        try (FileWriter w = new FileWriter(f);){
            gson.toJson(autoLoginMap, (Appendable)w);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadFail() {
        File f = FAIL_PATH.toFile();
        if (!f.exists()) {
            return;
        }
        try (FileReader r = new FileReader(f);){
            Type t = new TypeToken<Map<String, FailInfo>>(){}.getType();
            Map m = (Map)gson.fromJson((Reader)r, t);
            if (m != null) {
                failMap.putAll(m);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void saveFail() {
        File f = FAIL_PATH.toFile();
        try (FileWriter w = new FileWriter(f);){
            gson.toJson(failMap, (Appendable)w);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (OfflineAuthHandler.isOfflinePlayer(player)) {
            String name = player.m_7755_().getString();
            loggedIn.remove(name);
            joinTimeMap.put(name, System.currentTimeMillis());
            notLoggedTick.put(name, 0);
            notLoggedSpawnPos.put(name, new double[]{player.m_20185_(), player.m_20186_(), player.m_20189_()});
            String ip = OfflineAuthHandler.getPlayerIp(player);
            AutoLoginInfo info = autoLoginMap.get(name);
            if (OfflineAuthHandler.config.autoLoginEnable && info != null && info.ip != null && info.ip.equals(ip) && System.currentTimeMillis() - info.lastLoginTime < (long)OfflineAuthHandler.config.autoLoginExpireSeconds * 1000L && storage.isRegistered(name)) {
                loggedIn.add(name);
                joinTimeMap.remove(name);
                notLoggedTick.remove(name);
                notLoggedSpawnPos.remove(name);
                OfflineAuthHandler.restoreInventoryIfNeeded(player);
                player.m_20331_(false);
                player.m_213846_((Component)Component.m_237113_((String)config.msg("auto_login_success")));
                player.m_213846_((Component)Component.m_237113_((String)config.msg("auto_login_warn")));
                return;
            }
            if (storage.isRegistered(name)) {
                if (!inventoryBackup.containsKey(name) && !OfflineAuthHandler.hasInventoryFile(name)) {
                    ItemStack[] inv = new ItemStack[player.m_150109_().m_6643_()];
                    for (int i = 0; i < inv.length; ++i) {
                        inv[i] = player.m_150109_().m_8020_(i).m_41777_();
                    }
                    OfflineAuthHandler.backupInventory(name, inv);
                    player.m_150109_().m_6211_();
                } else if (!inventoryBackup.containsKey(name) && OfflineAuthHandler.hasInventoryFile(name)) {
                    player.m_150109_().m_6211_();
                }
            }
            player.m_20331_(true);
        } else {
            player.m_20331_(false);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        String name = player2.m_7755_().getString();
        if (OfflineAuthHandler.isOfflinePlayer(player2) && !loggedIn.contains(name)) {
            double[] pos = notLoggedSpawnPos.getOrDefault(name, new double[]{player2.m_20185_(), player2.m_20186_(), player2.m_20189_()});
            player2.m_6021_(pos[0], pos[1], pos[2]);
            Long joinTime = joinTimeMap.get(name);
            if (joinTime != null && System.currentTimeMillis() - joinTime > (long)OfflineAuthHandler.config.timeoutSeconds * 1000L) {
                player2.f_8906_.m_9942_((Component)Component.m_237113_((String)config.msg("timeout")));
                joinTimeMap.remove(name);
                notLoggedTick.remove(name);
                notLoggedSpawnPos.remove(name);
                return;
            }
            int tick = notLoggedTick.getOrDefault(name, 0) + 1;
            if (tick >= 100) {
                if (!storage.isRegistered(name)) {
                    player2.m_213846_((Component)Component.m_237113_((String)config.msg("register_prompt")));
                } else {
                    player2.m_213846_((Component)Component.m_237113_((String)config.msg("login_prompt")));
                }
                tick = 0;
            }
            notLoggedTick.put(name, tick);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        String name = player.m_7755_().getString();
        loggedIn.remove(name);
        joinTimeMap.remove(name);
        notLoggedTick.remove(name);
        notLoggedSpawnPos.remove(name);
    }

    @SubscribeEvent
    public static void onChat(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        if (OfflineAuthHandler.isOfflinePlayer(player) && !loggedIn.contains(player.m_7755_().getString())) {
            event.setCanceled(true);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("chat_blocked")));
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ServerPlayer player;
        Player player2 = event.getPlayer();
        if (player2 instanceof ServerPlayer && OfflineAuthHandler.isOfflinePlayer(player = (ServerPlayer)player2) && !loggedIn.contains(player.m_7755_().getString())) {
            event.setCanceled(true);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("break_blocked")));
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        ServerPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && OfflineAuthHandler.isOfflinePlayer(player = (ServerPlayer)entity) && !loggedIn.contains(player.m_7755_().getString())) {
            event.setCanceled(true);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("place_blocked")));
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        if (OfflineAuthHandler.isOfflinePlayer(player) && !loggedIn.contains(player.m_7755_().getString())) {
            event.setCanceled(true);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("drop_blocked")));
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && OfflineAuthHandler.isOfflinePlayer(player = (ServerPlayer)player2) && !loggedIn.contains(player.m_7755_().getString())) {
            event.setCanceled(true);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("pickup_blocked")));
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickItem event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && OfflineAuthHandler.isOfflinePlayer(player = (ServerPlayer)player2) && !loggedIn.contains(player.m_7755_().getString())) {
            event.setCanceled(true);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("use_blocked")));
        }
    }

    private static void backupInventory(String name, ItemStack[] inv) {
        inventoryBackup.put(name, inv);
        try {
            if (!Files.exists(INVENTORY_DIR, new LinkOption[0])) {
                Files.createDirectories(INVENTORY_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = INVENTORY_DIR.resolve(name + ".json").toFile();
        try (FileOutputStream fos = new FileOutputStream(file);){
            ListTag list = new ListTag();
            for (ItemStack stack : inv) {
                list.add((Object)stack.m_41739_(new CompoundTag()));
            }
            CompoundTag root = new CompoundTag();
            root.m_128365_("items", (Tag)list);
            NbtIo.m_128947_((CompoundTag)root, (OutputStream)fos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean hasInventoryFile(String name) {
        File file = INVENTORY_DIR.resolve(name + ".json").toFile();
        return file.exists();
    }

    private static ItemStack[] loadBackupInventory(String name, int size) {
        ItemStack[] itemStackArray;
        if (inventoryBackup.containsKey(name)) {
            return inventoryBackup.get(name);
        }
        File file = INVENTORY_DIR.resolve(name + ".json").toFile();
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            int i;
            CompoundTag root = NbtIo.m_128939_((InputStream)fis);
            ListTag list = root.m_128437_("items", 10);
            ItemStack[] inv = new ItemStack[size];
            for (i = 0; i < inv.length && i < list.size(); ++i) {
                inv[i] = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
            }
            for (i = list.size(); i < inv.length; ++i) {
                inv[i] = ItemStack.f_41583_;
            }
            inventoryBackup.put(name, inv);
            itemStackArray = inv;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        fis.close();
        return itemStackArray;
    }

    private static void removeBackup(String name) {
        inventoryBackup.remove(name);
        File file = INVENTORY_DIR.resolve(name + ".json").toFile();
        if (file.exists()) {
            file.delete();
        }
    }

    private static void restoreInventoryIfNeeded(ServerPlayer player) {
        String name = player.m_7755_().getString();
        ItemStack[] backup = OfflineAuthHandler.loadBackupInventory(name, player.m_150109_().m_6643_());
        if (backup != null) {
            for (int i = 0; i < backup.length; ++i) {
                player.m_150109_().m_6836_(i, backup[i]);
            }
            OfflineAuthHandler.removeBackup(name);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("inventory_restored")));
        }
    }

    private static boolean checkFailBlock(ServerPlayer player, String name) {
        if (!OfflineAuthHandler.config.failBlockEnable) {
            return false;
        }
        FailInfo fi = failMap.get(name);
        if (fi != null && fi.lockUntil > System.currentTimeMillis()) {
            HashMap<String, String> map = new HashMap<String, String>();
            long left = (fi.lockUntil - System.currentTimeMillis()) / 1000L + 1L;
            map.put("lock", String.valueOf(left));
            player.m_213846_((Component)Component.m_237113_((String)config.msg("fail_blocked", map)));
            return true;
        }
        return false;
    }

    private static boolean recordFail(ServerPlayer player, String name) {
        if (!OfflineAuthHandler.config.failBlockEnable) {
            return false;
        }
        FailInfo fi = failMap.getOrDefault(name, new FailInfo());
        ++fi.failCount;
        fi.lastFailTime = System.currentTimeMillis();
        boolean kicked = false;
        if (fi.failCount >= OfflineAuthHandler.config.maxFailAttempts) {
            fi.lockUntil = System.currentTimeMillis() + (long)OfflineAuthHandler.config.failLockSeconds * 1000L;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("lock", String.valueOf(OfflineAuthHandler.config.failLockSeconds));
            player.f_8906_.m_9942_((Component)Component.m_237113_((String)config.msg("fail_blocked", map)));
            kicked = true;
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("left", String.valueOf(OfflineAuthHandler.config.maxFailAttempts - fi.failCount));
            player.m_213846_((Component)Component.m_237113_((String)config.msg("fail_attempts_left", map)));
        }
        failMap.put(name, fi);
        OfflineAuthHandler.saveFail();
        return kicked;
    }

    private static void clearFail(String name) {
        if (failMap.remove(name) != null) {
            OfflineAuthHandler.saveFail();
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"register").then(Commands.m_82129_((String)"password", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"confirm", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (OfflineAuthHandler.checkFailBlock(player, name = player.m_7755_().getString())) {
                return 1;
            }
            String pwd = StringArgumentType.getString((CommandContext)ctx, (String)"password");
            String confirm = StringArgumentType.getString((CommandContext)ctx, (String)"confirm");
            if (!OfflineAuthHandler.isOfflinePlayer(player)) {
                player.m_213846_((Component)Component.m_237113_((String)config.msg("no_permission_register")));
                return 1;
            }
            if (!pwd.equals(confirm)) {
                OfflineAuthHandler.recordFail(player, name);
                return 1;
            }
            if (storage.isRegistered(name)) {
                player.m_213846_((Component)Component.m_237113_((String)config.msg("already_registered")));
                return 1;
            }
            storage.register(name, pwd);
            loggedIn.add(name);
            joinTimeMap.remove(name);
            notLoggedTick.remove(name);
            notLoggedSpawnPos.remove(name);
            OfflineAuthHandler.restoreInventoryIfNeeded(player);
            player.m_20331_(false);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("register_success")));
            OfflineAuthHandler.clearFail(name);
            if (OfflineAuthHandler.config.autoLoginEnable) {
                String ip = OfflineAuthHandler.getPlayerIp(player);
                AutoLoginInfo info = new AutoLoginInfo();
                info.ip = ip;
                info.lastLoginTime = System.currentTimeMillis();
                autoLoginMap.put(name, info);
                OfflineAuthHandler.saveAutoLogin();
            }
            return 1;
        }))));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"reg").then(Commands.m_82129_((String)"password", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"confirm", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (OfflineAuthHandler.checkFailBlock(player, name = player.m_7755_().getString())) {
                return 1;
            }
            String pwd = StringArgumentType.getString((CommandContext)ctx, (String)"password");
            String confirm = StringArgumentType.getString((CommandContext)ctx, (String)"confirm");
            if (!OfflineAuthHandler.isOfflinePlayer(player)) {
                player.m_213846_((Component)Component.m_237113_((String)config.msg("no_permission_register")));
                return 1;
            }
            if (!pwd.equals(confirm)) {
                OfflineAuthHandler.recordFail(player, name);
                return 1;
            }
            if (storage.isRegistered(name)) {
                player.m_213846_((Component)Component.m_237113_((String)config.msg("already_registered")));
                return 1;
            }
            storage.register(name, pwd);
            loggedIn.add(name);
            joinTimeMap.remove(name);
            notLoggedTick.remove(name);
            notLoggedSpawnPos.remove(name);
            OfflineAuthHandler.restoreInventoryIfNeeded(player);
            player.m_20331_(false);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("register_success")));
            OfflineAuthHandler.clearFail(name);
            if (OfflineAuthHandler.config.autoLoginEnable) {
                String ip = OfflineAuthHandler.getPlayerIp(player);
                AutoLoginInfo info = new AutoLoginInfo();
                info.ip = ip;
                info.lastLoginTime = System.currentTimeMillis();
                autoLoginMap.put(name, info);
                OfflineAuthHandler.saveAutoLogin();
            }
            return 1;
        }))));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"login").then(Commands.m_82129_((String)"password", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (OfflineAuthHandler.checkFailBlock(player, name = player.m_7755_().getString())) {
                return 1;
            }
            String pwd = StringArgumentType.getString((CommandContext)ctx, (String)"password");
            if (!OfflineAuthHandler.isOfflinePlayer(player)) {
                player.m_213846_((Component)Component.m_237113_((String)config.msg("no_permission_login")));
                return 1;
            }
            if (!storage.isRegistered(name)) {
                player.m_213846_((Component)Component.m_237113_((String)config.msg("not_registered")));
                return 1;
            }
            if (!storage.checkPassword(name, pwd)) {
                OfflineAuthHandler.recordFail(player, name);
                return 1;
            }
            loggedIn.add(name);
            joinTimeMap.remove(name);
            notLoggedTick.remove(name);
            notLoggedSpawnPos.remove(name);
            OfflineAuthHandler.restoreInventoryIfNeeded(player);
            player.m_20331_(false);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("login_success")));
            OfflineAuthHandler.clearFail(name);
            if (OfflineAuthHandler.config.autoLoginEnable) {
                String ip = OfflineAuthHandler.getPlayerIp(player);
                AutoLoginInfo info = new AutoLoginInfo();
                info.ip = ip;
                info.lastLoginTime = System.currentTimeMillis();
                autoLoginMap.put(name, info);
                OfflineAuthHandler.saveAutoLogin();
            }
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"l").then(Commands.m_82129_((String)"password", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (OfflineAuthHandler.checkFailBlock(player, name = player.m_7755_().getString())) {
                return 1;
            }
            String pwd = StringArgumentType.getString((CommandContext)ctx, (String)"password");
            if (!OfflineAuthHandler.isOfflinePlayer(player)) {
                player.m_213846_((Component)Component.m_237113_((String)config.msg("no_permission_login")));
                return 1;
            }
            if (!storage.isRegistered(name)) {
                player.m_213846_((Component)Component.m_237113_((String)config.msg("not_registered")));
                return 1;
            }
            if (!storage.checkPassword(name, pwd)) {
                OfflineAuthHandler.recordFail(player, name);
                return 1;
            }
            loggedIn.add(name);
            joinTimeMap.remove(name);
            notLoggedTick.remove(name);
            notLoggedSpawnPos.remove(name);
            OfflineAuthHandler.restoreInventoryIfNeeded(player);
            player.m_20331_(false);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("login_success")));
            OfflineAuthHandler.clearFail(name);
            if (OfflineAuthHandler.config.autoLoginEnable) {
                String ip = OfflineAuthHandler.getPlayerIp(player);
                AutoLoginInfo info = new AutoLoginInfo();
                info.ip = ip;
                info.lastLoginTime = System.currentTimeMillis();
                autoLoginMap.put(name, info);
                OfflineAuthHandler.saveAutoLogin();
            }
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"changepassword").then(Commands.m_82129_((String)"old", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"new", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (OfflineAuthHandler.checkFailBlock(player, name = player.m_7755_().getString())) {
                return 1;
            }
            String oldPwd = StringArgumentType.getString((CommandContext)ctx, (String)"old");
            String newPwd = StringArgumentType.getString((CommandContext)ctx, (String)"new");
            if (!OfflineAuthHandler.isOfflinePlayer(player)) {
                player.m_213846_((Component)Component.m_237113_((String)config.msg("no_permission_changepwd")));
                return 1;
            }
            if (!storage.isRegistered(name) || !storage.checkPassword(name, oldPwd)) {
                OfflineAuthHandler.recordFail(player, name);
                return 1;
            }
            storage.changePassword(name, newPwd);
            player.m_213846_((Component)Component.m_237113_((String)config.msg("changepwd_success")));
            OfflineAuthHandler.clearFail(name);
            if (OfflineAuthHandler.config.autoLoginEnable) {
                String ip = OfflineAuthHandler.getPlayerIp(player);
                AutoLoginInfo info = new AutoLoginInfo();
                info.ip = ip;
                info.lastLoginTime = System.currentTimeMillis();
                autoLoginMap.put(name, info);
                OfflineAuthHandler.saveAutoLogin();
            }
            return 1;
        }))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"auth").then(Commands.m_82127_((String)"help").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            player.m_213846_((Component)Component.m_237113_((String)config.msg("help_header")));
            player.m_213846_((Component)Component.m_237113_((String)config.msg("help_register")));
            player.m_213846_((Component)Component.m_237113_((String)config.msg("help_login")));
            player.m_213846_((Component)Component.m_237113_((String)config.msg("help_changepwd")));
            return 1;
        }))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (!player.m_20310_(2)) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u4f60\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u547d\u4ee4\uff01"));
                return 1;
            }
            AuthConfig.loadConfig();
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7aOfflineAuth \u914d\u7f6e\u5df2\u91cd\u65b0\u52a0\u8f7d\uff01"));
            return 1;
        })));
    }

    static {
        try {
            if (!Files.exists(BASE_DIR, new LinkOption[0])) {
                Files.createDirectories(BASE_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(INVENTORY_DIR, new LinkOption[0])) {
                Files.createDirectories(INVENTORY_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        OfflineAuthHandler.loadAutoLogin();
        OfflineAuthHandler.loadFail();
    }

    public static class AutoLoginInfo {
        public String ip;
        public long lastLoginTime;
    }

    public static class FailInfo {
        public int failCount;
        public long lastFailTime;
        public long lockUntil;
    }
}

