/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.offlineauth;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class JsonAuthStorage {
    private static final String DIR = "config/offlineauth";
    private static final String FILE_NAME = "auth.json";
    private static final Path FILE_PATH = Path.of("config/offlineauth", "auth.json");
    private static final Gson gson = new Gson();
    private Map<String, String> credentials = new HashMap<String, String>();
    private long lastModified = -1L;

    public JsonAuthStorage() {
        this.load();
    }

    private void reloadIfChanged() {
        File file = FILE_PATH.toFile();
        if (!file.exists()) {
            this.credentials = new HashMap<String, String>();
            this.lastModified = -1L;
            return;
        }
        long lm = file.lastModified();
        if (lm != this.lastModified) {
            this.load();
        }
    }

    private void load() {
        File file;
        this.credentials = new HashMap<String, String>();
        File dir = new File(DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = FILE_PATH.toFile()).exists()) {
            this.save();
            this.lastModified = file.exists() ? file.lastModified() : -1L;
            return;
        }
        try (FileReader reader = new FileReader(file);){
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map map = (Map)gson.fromJson((Reader)reader, type);
            if (map != null) {
                this.credentials.putAll(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lastModified = file.lastModified();
    }

    private void save() {
        File dir = new File(DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try (FileWriter writer = new FileWriter(FILE_PATH.toFile());){
            gson.toJson(this.credentials, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = FILE_PATH.toFile();
        this.lastModified = file.exists() ? file.lastModified() : -1L;
    }

    public boolean isRegistered(String name) {
        this.reloadIfChanged();
        return this.credentials.containsKey(name);
    }

    public void register(String name, String password) {
        this.reloadIfChanged();
        this.credentials.put(name, password);
        this.save();
    }

    public boolean checkPassword(String name, String password) {
        this.reloadIfChanged();
        return this.credentials.containsKey(name) && this.credentials.get(name).equals(password);
    }

    public void changePassword(String name, String newPassword) {
        this.reloadIfChanged();
        if (this.credentials.containsKey(name)) {
            this.credentials.put(name, newPassword);
            this.save();
        }
    }
}

