/*
 * Decompiled with CFR 0.152.
 */
package wueffi.regreader;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wueffi.regreader.HUDManager;
import wueffi.regreader.RedstoneRegister;
import wueffi.regreader.RegReaderConfig;
import wueffi.regreader.RegReaderHUD;
import wueffi.regreader.RegisterManager;

@Environment(value=EnvType.CLIENT)
public class HUDRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RegReader");

    public static void initialize() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            class_310 client = class_310.method_1551();
            if (!RegReaderConfig.isHudEnabled()) {
                return;
            }
            for (RegReaderHUD hud : HUDManager.getHUDs()) {
                int baseHeight = 10;
                int lineHeight = 12;
                int registerCount = RegisterManager.getRegisters(hud.getHUDName()).size();
                int rectangleHeight = baseHeight + (registerCount - 1) * lineHeight + 2;
                String hudColor = hud.getHUDColor();
                int rectangleWidth = hud.getRectangleWidth();
                int displayBase = hud.getDisplayBase();
                int rectangleX = hud.getxPos();
                int rectangleY = hud.getyPos();
                boolean coloredNames = Boolean.TRUE.equals(hud.getColoredNames());
                if (hudColor.startsWith("#")) {
                    hudColor = hudColor.substring(1);
                }
                try {
                    long color = HUDRenderer.parseColor(hudColor);
                    drawContext.method_25294(rectangleX, rectangleY, rectangleX + rectangleWidth, rectangleY + rectangleHeight, 0x55FFFFFF);
                    drawContext.method_49601(rectangleX, rectangleY, rectangleWidth, rectangleHeight, (int)color);
                    class_4587 matrices = drawContext.method_51448();
                    if (RegReaderConfig.getTitleMode()) {
                        matrices.method_22903();
                        float scale = 0.8f;
                        matrices.method_46416((float)hud.xPos.intValue(), (float)(hud.yPos - 8), 0.0f);
                        matrices.method_22905(scale, scale, 1.0f);
                        if (coloredNames) {
                            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)hud.getHUDName()).method_27694(style -> style.method_36139((int)color)), 0, 0, (int)color, true);
                        } else {
                            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)hud.getHUDName()), 0, 0, -1, true);
                        }
                        matrices.method_22909();
                    }
                    int yOffset = rectangleY + 2;
                    for (RedstoneRegister register : RegisterManager.getRegisters(hud.getHUDName())) {
                        int value = register.readValue();
                        int bitSize = register.bits;
                        String formattedValue = HUDRenderer.formatValue(value, displayBase, bitSize);
                        String registerName = register.name + ": ";
                        String registerValue = formattedValue;
                        if (coloredNames) {
                            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)registerName).method_27694(style -> style.method_36139((int)color)), rectangleX + 4, yOffset, (int)color, true);
                        } else {
                            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)registerName), rectangleX + 4, yOffset, -1, true);
                        }
                        drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)registerValue), rectangleX + 4 + client.field_1772.method_1727(registerName), yOffset, -1, true);
                        yOffset += lineHeight;
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Invalid HUD color format for '{}': {}", new Object[]{hud.getHUDName(), hudColor, e});
                    drawContext.method_25294(rectangleX, rectangleY, rectangleX + rectangleWidth, rectangleY + rectangleHeight, 0xFF0000);
                }
            }
        });
    }

    private static long parseColor(String hudColor) {
        try {
            if (hudColor.length() == 8) {
                return Long.parseLong(hudColor, 16);
            }
            if (hudColor.length() == 6) {
                return Long.parseLong(hudColor, 16) | 0xFFFFFFFFFF000000L;
            }
            throw new NumberFormatException("Invalid color format");
        }
        catch (NumberFormatException e) {
            LOGGER.error("Failed to parse HUD color: {}", (Object)hudColor, (Object)e);
            return -1L;
        }
    }

    private static String formatValue(int value, int base, int bitSize) {
        switch (base) {
            case 2: {
                return "0b" + String.format("%" + bitSize + "s", Integer.toBinaryString(value & (1 << bitSize) - 1)).replace(' ', '0');
            }
            case 8: {
                int octalDigits = (int)Math.ceil((double)bitSize / 3.0);
                return "0o" + String.format("%" + octalDigits + "s", Integer.toOctalString(value & (1 << bitSize) - 1)).replace(' ', '0');
            }
            case 16: {
                int hexDigits = (int)Math.ceil((double)bitSize / 4.0);
                return "0x" + String.format("%" + hexDigits + "s", Integer.toHexString(value & (1 << bitSize) - 1)).replace(' ', '0').toUpperCase();
            }
        }
        return String.valueOf(value);
    }
}

