/*
 * Decompiled with CFR 0.152.
 */
package wueffi.regreader;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2453;
import net.minecraft.class_2459;
import net.minecraft.class_2462;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import wueffi.regreader.RedstoneRegister;
import wueffi.regreader.RegisterManager;

@Environment(value=EnvType.CLIENT)
public class RedstoneReader {
    private static int tickCounter = 0;

    public static void initialize() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (tickCounter++ >= 2) {
                tickCounter = 0;
                RedstoneReader.readAllRegisters();
            }
        });
    }

    private static void readAllRegisters() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        for (RedstoneRegister register : RegisterManager.getAllRegisters()) {
            class_2338 pos = register.getPosition();
            if (pos == null) continue;
            int value = RedstoneReader.readRedstoneSignal((class_1937)client.field_1687, pos, register.bits, register.spacing, register.inverted);
            register.setLastReadValue(value);
        }
    }

    private static int readRedstoneSignal(class_1937 world, class_2338 pos, int bits, int spacing, boolean inverted) {
        int value = 0;
        for (int i = 0; i < bits; ++i) {
            class_2338 signalPos = pos.method_10079(class_2350.field_11033, i * spacing);
            class_2248 block = world.method_8320(signalPos).method_26204();
            boolean isPowered = false;
            if (block instanceof class_2459) {
                isPowered = (Boolean)world.method_8320(signalPos).method_11654((class_2769)class_2741.field_12548);
            } else if (block instanceof class_2462) {
                isPowered = (Boolean)world.method_8320(signalPos).method_11654((class_2769)class_2741.field_12484);
            } else if (block instanceof class_2453) {
                isPowered = (Boolean)world.method_8320(signalPos).method_11654((class_2769)class_2741.field_12548);
            }
            if (!isPowered) continue;
            value |= 1 << bits - 1 - i;
        }
        int finalValue = inverted ? ~value & (1 << bits) - 1 : value;
        return finalValue;
    }
}

