/*
 * Decompiled with CFR 0.152.
 */
package wueffi.regreader.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import wueffi.regreader.HUDManager;
import wueffi.regreader.RedstoneRegister;
import wueffi.regreader.RegReaderHUD;
import wueffi.regreader.RegisterManager;

@Environment(value=EnvType.CLIENT)
public class AssignHUDCommand {
    private static final SuggestionProvider<FabricClientCommandSource> REGISTER_SUGGESTIONS = (context, builder) -> {
        for (RedstoneRegister register : RegisterManager.getAllRegisters()) {
            builder.suggest(register.name);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        AssignHUDCommand.registerCommand(dispatcher, "regreader");
        AssignHUDCommand.registerCommand(dispatcher, "rr");
    }

    private static void registerCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, String rootCommand) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)rootCommand).then(ClientCommandManager.literal((String)"assignHUD").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(REGISTER_SUGGESTIONS).then(ClientCommandManager.argument((String)"HUD", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (RegReaderHUD hud : HUDManager.getHUDs()) {
                builder.suggest(hud.getHUDName());
            }
            return builder.buildFuture();
        }).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            RedstoneRegister Reg = RegisterManager.findRegisterByName(name);
            String hud = StringArgumentType.getString((CommandContext)context, (String)"HUD");
            RegReaderHUD HUD = HUDManager.findHUDByName(hud);
            if (HUD == null) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("HUD " + hud + " not found.")));
                return 0;
            }
            if (Reg == null) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Couldn't find register '" + name + "'")));
                return 0;
            }
            Reg.setAssignedHUD(hud);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Assigned register '" + name + "' to HUD " + hud + ".")));
            return 1;
        })))));
    }
}

