/*
 * Decompiled with CFR 0.152.
 */
package wueffi.regreader.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import wueffi.regreader.HUDManager;
import wueffi.regreader.RegReaderConfig;
import wueffi.regreader.RegReaderHUD;
import wueffi.regreader.RegisterManager;

@Environment(value=EnvType.CLIENT)
public class HUDCommand {
    private static final List<Integer> validBases = Arrays.asList(2, 8, 10, 16);
    private static final SuggestionProvider<FabricClientCommandSource> HUD_SUGGESTIONS = (context, builder) -> {
        builder.suggest("toggle");
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        HUDCommand.registerCommand(dispatcher, "regreader");
        HUDCommand.registerCommand(dispatcher, "rr");
    }

    private static void registerCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, String rootCommand) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)rootCommand).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"hud").then(ClientCommandManager.argument((String)"state", (ArgumentType)StringArgumentType.word()).suggests(HUD_SUGGESTIONS).executes(context -> {
            String state = StringArgumentType.getString((CommandContext)context, (String)"state");
            boolean hudEnabled = RegReaderConfig.isHudEnabled();
            if (state.equalsIgnoreCase("toggle")) {
                RegisterManager.setHudEnabled(!hudEnabled);
            } else if (state.equalsIgnoreCase("on")) {
                RegisterManager.setHudEnabled(true);
            } else if (state.equalsIgnoreCase("off")) {
                RegisterManager.setHudEnabled(false);
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Invalid argument!"));
                return 0;
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("All HUD's are now " + (RegReaderConfig.isHudEnabled() ? "enabled" : "disabled"))));
            return 1;
        }))).then(ClientCommandManager.literal((String)"color").then(ClientCommandManager.argument((String)"HUD", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (RegReaderHUD hud : HUDManager.getHUDs()) {
                builder.suggest(hud.getHUDName());
            }
            return builder.buildFuture();
        }).then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String color = StringArgumentType.getString((CommandContext)context, (String)"color");
            String hud = StringArgumentType.getString((CommandContext)context, (String)"HUD");
            if (color.matches("^#[0-9A-Fa-f]{8}$")) {
                RegReaderHUD HUD = HUDManager.findHUDByName(hud);
                if (HUD == null) {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("HUD " + hud + " not found.")));
                    return 0;
                }
                HUD.setHUDColor(color);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(hud + " color set to " + color)));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Invalid color format. Please use a valid hex color code (#AARRGGBB). Remember to use '"));
            }
            return 1;
        }))))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            if (!name.isEmpty()) {
                HUDManager.addHUD(name, "#FFFFFF", 10, true, 80, 100, 12);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Added HUD: " + name)));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Name can not be empty!"));
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (RegReaderHUD hud : HUDManager.getHUDs()) {
                builder.suggest(hud.getHUDName());
            }
            return builder.buildFuture();
        }).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            if (!name.isEmpty()) {
                HUDManager.removeHUD(name);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Removed HUD: " + name)));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Name can not be empty!"));
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"rename").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (RegReaderHUD hud : HUDManager.getHUDs()) {
                builder.suggest(hud.getHUDName());
            }
            return builder.buildFuture();
        }).then(ClientCommandManager.argument((String)"newName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            String newName = StringArgumentType.getString((CommandContext)context, (String)"newName");
            if (name.isEmpty() || newName.isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Name and new Name can not be empty!"));
                return 0;
            }
            if (!HUDManager.renameHUD(name, newName)) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Could not rename HUD."));
                return 0;
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Renamed HUD: " + name + " to: " + newName)));
            return 1;
        }))))).then(ClientCommandManager.literal((String)"setDisplayBase").then(ClientCommandManager.argument((String)"HUD", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (RegReaderHUD hud : HUDManager.getHUDs()) {
                builder.suggest(hud.getHUDName());
            }
            return builder.buildFuture();
        }).then(ClientCommandManager.argument((String)"base", (ArgumentType)IntegerArgumentType.integer((int)2, (int)16)).suggests((context, builder) -> {
            for (int base : validBases) {
                builder.suggest(base);
            }
            return builder.buildFuture();
        }).executes(context -> {
            int base = IntegerArgumentType.getInteger((CommandContext)context, (String)"base");
            String hud = StringArgumentType.getString((CommandContext)context, (String)"HUD");
            if (validBases.contains(base)) {
                RegReaderHUD HUD = HUDManager.findHUDByName(hud);
                if (HUD == null) {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("HUD " + hud + " not found.")));
                    return 0;
                }
                HUD.setDisplayBase(base);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(hud + " base set to " + base)));
                return 1;
            }
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Invalid base! Use 2, 8, 10, or 16."));
            return 0;
        }))))).then(ClientCommandManager.literal((String)"setColoredNames").then(ClientCommandManager.argument((String)"HUD", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (RegReaderHUD hud : HUDManager.getHUDs()) {
                builder.suggest(hud.getHUDName());
            }
            return builder.buildFuture();
        }).then(ClientCommandManager.argument((String)"Boolean", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean setting = BoolArgumentType.getBool((CommandContext)context, (String)"Boolean");
            String hud = StringArgumentType.getString((CommandContext)context, (String)"HUD");
            RegReaderHUD HUD = HUDManager.findHUDByName(hud);
            if (HUD == null) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("HUD " + hud + " not found.")));
                return 0;
            }
            HUD.setColoredNames(setting);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(hud + " Colored names set to " + setting)));
            return 1;
        }))))).then(ClientCommandManager.literal((String)"setHUDSize").then(ClientCommandManager.argument((String)"HUD", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (RegReaderHUD hud : HUDManager.getHUDs()) {
                builder.suggest(hud.getHUDName());
            }
            return builder.buildFuture();
        }).then(ClientCommandManager.argument((String)"Width", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int Width = IntegerArgumentType.getInteger((CommandContext)context, (String)"Width");
            String hud = StringArgumentType.getString((CommandContext)context, (String)"HUD");
            RegReaderHUD HUD = HUDManager.findHUDByName(hud);
            if (HUD == null) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("HUD " + hud + " not found.")));
                return 0;
            }
            HUD.setRectangleWidth(Width);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(hud + " Width set to " + Width)));
            return 1;
        }))))).then(ClientCommandManager.literal((String)"setHUDPos").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"HUD", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (RegReaderHUD hud : HUDManager.getHUDs()) {
                builder.suggest(hud.getHUDName());
            }
            return builder.buildFuture();
        }).then(ClientCommandManager.literal((String)"X").then(ClientCommandManager.argument((String)"XPos", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int X = IntegerArgumentType.getInteger((CommandContext)context, (String)"XPos");
            String hud = StringArgumentType.getString((CommandContext)context, (String)"HUD");
            RegReaderHUD HUD = HUDManager.findHUDByName(hud);
            if (HUD == null) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("HUD " + hud + " not found.")));
                return 0;
            }
            HUD.setxPos(X);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(hud + " X-Position set to " + X)));
            return 1;
        })))).then(ClientCommandManager.literal((String)"Y").then(ClientCommandManager.argument((String)"YPos", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int Y = IntegerArgumentType.getInteger((CommandContext)context, (String)"YPos");
            String hud = StringArgumentType.getString((CommandContext)context, (String)"HUD");
            RegReaderHUD HUD = HUDManager.findHUDByName(hud);
            if (HUD == null) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("HUD " + hud + " not found.")));
                return 0;
            }
            HUD.setyPos(Y);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(hud + " Y-Position set to " + Y)));
            return 1;
        })))))));
    }
}

