/*
 * Decompiled with CFR 0.152.
 */
package wueffi.regreader.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import wueffi.regreader.utils.ProfileUtils;

@Environment(value=EnvType.CLIENT)
public class ProfileCommand {
    private static final SuggestionProvider<FabricClientCommandSource> PROFILE_NAME_SUGGESTIONS = (context, builder) -> {
        List<String> profiles = ProfileUtils.getAvailableProfiles();
        for (String profile : profiles) {
            builder.suggest(profile);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        ProfileCommand.registerCommand(dispatcher, "regreader");
        ProfileCommand.registerCommand(dispatcher, "rr");
    }

    private static void registerCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, String rootCommand) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)rootCommand).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"profile").then(ClientCommandManager.literal((String)"save").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            if (ProfileUtils.saveProfile(name)) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Profile '" + name + "' saved.")));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Failed to save profile '" + name + "'!")));
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"load").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(PROFILE_NAME_SUGGESTIONS).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            if (ProfileUtils.loadProfile(name)) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Loaded profile '" + name + "'.")));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Profile '" + name + "' not found!")));
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"delete").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(PROFILE_NAME_SUGGESTIONS).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            if (ProfileUtils.deleteProfile(name)) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Deleted profile '" + name + "'.")));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Profile '" + name + "' not found!")));
            }
            return 1;
        })))));
    }
}

