/*
 * Decompiled with CFR 0.152.
 */
package wueffi.regreader;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wueffi.regreader.RedstoneRegister;
import wueffi.regreader.RegReaderConfig;
import wueffi.regreader.RegisterManager;

@Environment(value=EnvType.CLIENT)
public class HUDRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RegReader");

    public static void initialize() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (!RegReaderConfig.isHudEnabled()) {
                LOGGER.info("HUD is disabled. Skipping render.");
                return;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null) {
                LOGGER.warn("Client player is null. Skipping HUD rendering.");
                return;
            }
            int baseHeight = 10;
            int lineHeight = 12;
            int registerCount = RegisterManager.getRegisters().size();
            int rectangleHeight = baseHeight + (registerCount - 1) * lineHeight + 2;
            String hudColor = RegReaderConfig.getHudColor();
            int rectangleWidth = RegReaderConfig.getRectangleWidth();
            int displayBase = RegReaderConfig.getDisplayBase();
            int rectangleX = RegReaderConfig.getXPos();
            int rectangleY = RegReaderConfig.getYPos();
            if (hudColor.startsWith("#")) {
                hudColor = hudColor.substring(1);
            }
            try {
                long color = HUDRenderer.parseColor(hudColor);
                drawContext.method_25294(rectangleX, rectangleY, rectangleX + rectangleWidth, rectangleY + rectangleHeight, 0x55FFFFFF);
                drawContext.method_49601(rectangleX, rectangleY, rectangleWidth, rectangleHeight, (int)color);
                int yOffset = rectangleY + 2;
                for (RedstoneRegister register : RegisterManager.getRegisters()) {
                    int value = register.readValue();
                    int bitSize = register.bits;
                    LOGGER.debug("Register {}: Value={}, BitSize={}", new Object[]{register.name, value, bitSize});
                    String formattedValue = HUDRenderer.formatValue(value, displayBase, bitSize);
                    LOGGER.debug("Formatted Value for {}: {}", (Object)register.name, (Object)formattedValue);
                    String text = register.name + ": " + formattedValue;
                    drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)text), rectangleX + 4, yOffset, -1, true);
                    yOffset += lineHeight;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid color format: {}", (Object)hudColor, (Object)e);
                drawContext.method_25294(rectangleX, rectangleY, rectangleX + rectangleWidth, rectangleY + rectangleHeight, 0xFFFFFF);
            }
        });
    }

    private static long parseColor(String hudColor) {
        try {
            if (hudColor.length() == 8) {
                return Long.parseLong(hudColor, 16);
            }
            if (hudColor.length() == 6) {
                return Long.parseLong(hudColor, 16) | 0xFFFFFFL;
            }
            throw new NumberFormatException("Invalid color format");
        }
        catch (NumberFormatException e) {
            LOGGER.error("Failed to parse HUD color: {}", (Object)hudColor, (Object)e);
            return -1L;
        }
    }

    private static String formatValue(int value, int base, int bitSize) {
        switch (base) {
            case 2: {
                return "0b" + String.format("%" + bitSize + "s", Integer.toBinaryString(value & (1 << bitSize) - 1)).replace(' ', '0');
            }
            case 8: {
                int octalDigits = (int)Math.ceil((double)bitSize / 3.0);
                return "0o" + String.format("%" + octalDigits + "s", Integer.toOctalString(value & (1 << bitSize) - 1)).replace(' ', '0');
            }
            case 16: {
                int hexDigits = (int)Math.ceil((double)bitSize / 4.0);
                return "0x" + String.format("%" + hexDigits + "s", Integer.toHexString(value & (1 << bitSize) - 1)).replace(' ', '0').toUpperCase();
            }
        }
        return String.valueOf(value);
    }
}

