/*
 * Decompiled with CFR 0.152.
 */
package wueffi.regreader;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wueffi.regreader.RedstoneRegister;
import wueffi.regreader.RegReaderConfig;

public class RegisterManager {
    private static final List<RedstoneRegister> registers = RegReaderConfig.registers;
    public static boolean hudEnabled = RegReaderConfig.isHudEnabled();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RegReader");

    public static void setHudEnabled(boolean enabled) {
        hudEnabled = enabled;
        RegReaderConfig.setHudEnabled(hudEnabled);
    }

    public static void setHudColor(String color) {
        if (color.matches("^#[0-9A-Fa-f]{6}$") || color.matches("^#[0-9A-Fa-f]{8}$")) {
            RegReaderConfig.setHudColor(color);
        } else {
            RegReaderConfig.setHudColor("#FFFFFFFF");
        }
    }

    public static List<RedstoneRegister> getRegisters() {
        return registers;
    }

    public static void addRegister(String name, Integer bits, Integer spacing, Boolean inverted) {
        int index;
        if (bits == null) {
            bits = 8;
        }
        if (spacing == null) {
            spacing = 2;
        }
        if (inverted == null) {
            inverted = false;
        }
        RedstoneRegister register = new RedstoneRegister(name, bits, spacing, inverted);
        for (index = 0; index < registers.size() && RegisterManager.registers.get((int)index).name.compareTo(register.name) < 0; ++index) {
        }
        RegReaderConfig.addRegister(index, register);
    }

    public static void removeRegister(String name) {
        RegReaderConfig.removeRegister(name);
    }

    public static void moveRegister(String name, String direction) {
        RedstoneRegister register = RegisterManager.findRegisterByName(name);
        if (register == null) {
            return;
        }
        int index = registers.indexOf(register);
        if (direction.equalsIgnoreCase("up") && index > 0) {
            Collections.swap(registers, index, index - 1);
        } else if (direction.equalsIgnoreCase("down") && index < registers.size() - 1) {
            Collections.swap(registers, index, index + 1);
        }
        RegReaderConfig.save();
    }

    public static void moveRegister(String name, int position) {
        RedstoneRegister register = RegisterManager.findRegisterByName(name);
        if (register == null || position < 0 || position >= registers.size()) {
            return;
        }
        registers.remove(register);
        registers.add(position, register);
        RegReaderConfig.save();
    }

    public static boolean renameRegister(String oldName, String newName) {
        RedstoneRegister register = RegisterManager.findRegisterByName(oldName);
        if (register == null || RegisterManager.findRegisterByName(newName) != null) {
            return false;
        }
        register.setName(newName);
        RegReaderConfig.save();
        return true;
    }

    static RedstoneRegister findRegisterByName(String name) {
        for (RedstoneRegister register : registers) {
            if (!register.name.equals(name)) continue;
            return register;
        }
        return null;
    }

    private static void sortRegistersAlphabetically() {
        registers.sort(Comparator.comparing(register -> register.name));
    }
}

