/*
 * Decompiled with CFR 0.152.
 */
package wueffi.regreader.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import wueffi.regreader.RegReaderConfig;

@Environment(value=EnvType.CLIENT)
public class ConfigCommand {
    private static final List<Integer> validBases = Arrays.asList(2, 8, 10, 16);

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"regreader").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"config").then(ClientCommandManager.literal((String)"reload").executes(context -> {
            RegReaderConfig.load();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config reloaded!"));
            return 1;
        }))).then(ClientCommandManager.literal((String)"setDisplayBase").then(ClientCommandManager.argument((String)"base", (ArgumentType)IntegerArgumentType.integer((int)2, (int)16)).suggests((context, builder) -> {
            for (int base : validBases) {
                builder.suggest(base);
            }
            return builder.buildFuture();
        }).executes(context -> {
            int base = IntegerArgumentType.getInteger((CommandContext)context, (String)"base");
            if (validBases.contains(base)) {
                RegReaderConfig.setDisplayBase(base);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Display base set to " + base)));
                return 1;
            }
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Invalid base! Use 2, 8, 10, or 16."));
            return 0;
        })))).then(ClientCommandManager.literal((String)"setHUDsize").then(ClientCommandManager.argument((String)"Width", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int Width = IntegerArgumentType.getInteger((CommandContext)context, (String)"Width");
            RegReaderConfig.setRectangleWidth(Width);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("HUD Width set to " + Width)));
            return 1;
        })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"setHUDPos").then(ClientCommandManager.literal((String)"X").then(ClientCommandManager.argument((String)"XPos", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int X = IntegerArgumentType.getInteger((CommandContext)context, (String)"XPos");
            RegReaderConfig.setHUDX(X);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("HUD X-Position set to " + X)));
            return 1;
        })))).then(ClientCommandManager.literal((String)"Y").then(ClientCommandManager.argument((String)"YPos", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int Y = IntegerArgumentType.getInteger((CommandContext)context, (String)"YPos");
            RegReaderConfig.setHUDY(Y);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("HUD Y-Position set to " + Y)));
            return 1;
        }))))));
    }
}

