/*
 * Decompiled with CFR 0.152.
 */
package wueffi.regreader.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import wueffi.regreader.RegReaderConfig;
import wueffi.regreader.RegisterManager;

@Environment(value=EnvType.CLIENT)
public class HUDCommand {
    private static final SuggestionProvider<FabricClientCommandSource> HUD_SUGGESTIONS = (context, builder) -> {
        builder.suggest("toggle");
        builder.suggest("on");
        builder.suggest("off");
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"regreader").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"hud").then(ClientCommandManager.argument((String)"state", (ArgumentType)StringArgumentType.word()).suggests(HUD_SUGGESTIONS).executes(context -> {
            String state = StringArgumentType.getString((CommandContext)context, (String)"state");
            boolean hudEnabled = RegReaderConfig.isHudEnabled();
            if (state.equalsIgnoreCase("toggle")) {
                RegisterManager.setHudEnabled(!hudEnabled);
            } else if (state.equalsIgnoreCase("on")) {
                RegisterManager.setHudEnabled(true);
            } else if (state.equalsIgnoreCase("off")) {
                RegisterManager.setHudEnabled(false);
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Invalid argument! Use 'toggle', 'on', or 'off'."));
                return 0;
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("HUD is now " + (RegReaderConfig.isHudEnabled() ? "enabled" : "disabled"))));
            return 1;
        }))).then(ClientCommandManager.literal((String)"color").then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String color = StringArgumentType.getString((CommandContext)context, (String)"color");
            if (color.matches("^#[0-9A-Fa-f]{8}$")) {
                RegReaderConfig.setHudColor(color);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("HUD color set to " + color)));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Invalid color format. Please use a valid hex color code (#AARRGGBB). Remember to use '"));
            }
            return 1;
        })))));
    }
}

