/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.client.handler;

import fuzs.universalenchants.handler.ItemCompatHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.Nullable;

public class ItemTooltipHandler {
    static final Component PLACEHOLDER_COMPONENT = Component.empty();

    public static void onItemTooltip(ItemStack itemStack, List<Component> tooltipLines, Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (!((ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY)).modifiers().isEmpty()) {
            Collection<EquipmentSlotGroup> equipmentSlotGroups = ItemTooltipHandler.getEquipmentSlotGroupsForRemoval(itemStack);
            for (EquipmentSlotGroup equipmentSlotGroup : equipmentSlotGroups) {
                boolean isRemoving = false;
                for (int i = 0; i < tooltipLines.size(); ++i) {
                    Component component2 = tooltipLines.get(i);
                    ComponentContents componentContents = component2.getContents();
                    if (componentContents instanceof TranslatableContents) {
                        TranslatableContents contents = (TranslatableContents)componentContents;
                        if (contents.getKey().equals("item.modifiers." + equipmentSlotGroup.getSerializedName())) {
                            isRemoving = true;
                            if (i - 1 >= 0 && tooltipLines.get(i - 1) == CommonComponents.EMPTY) {
                                tooltipLines.set(i - 1, PLACEHOLDER_COMPONENT);
                            }
                        } else if (!contents.getKey().startsWith("attribute.modifier.")) {
                            isRemoving = false;
                        }
                        if (!isRemoving) continue;
                        tooltipLines.set(i, PLACEHOLDER_COMPONENT);
                        continue;
                    }
                    isRemoving = false;
                }
            }
            tooltipLines.removeIf(component -> component == PLACEHOLDER_COMPONENT);
        }
    }

    private static Collection<EquipmentSlotGroup> getEquipmentSlotGroupsForRemoval(ItemStack itemStack) {
        Equippable equippable = (Equippable)itemStack.get(DataComponents.EQUIPPABLE);
        if (equippable != null && equippable.slot() == EquipmentSlot.BODY) {
            return ItemCompatHandler.ARMOR_EQUIPMENT_SLOT_GROUPS;
        }
        return Collections.singleton(EquipmentSlotGroup.BODY);
    }
}

