/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.handler;

import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.universalenchants.core.CompositeHolderSet;
import fuzs.universalenchants.init.ModRegistry;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemCompatHandler {
    public static final Set<EquipmentSlotGroup> ARMOR_EQUIPMENT_SLOT_GROUPS = Set.of(EquipmentSlotGroup.FEET, EquipmentSlotGroup.LEGS, EquipmentSlotGroup.CHEST, EquipmentSlotGroup.HEAD, EquipmentSlotGroup.ARMOR);
    static final ThreadLocal<Unit> IS_BLOCKING_WITH_SHIELD = new ThreadLocal();

    public static void onFinalizeItemComponents(Item item, Consumer<Function<DataComponentMap, DataComponentPatch>> consumer) {
        if (item instanceof ShearsItem || item instanceof ShieldItem) {
            consumer.accept(components -> DataComponentPatch.builder().set(DataComponents.ENCHANTABLE, (Object)new Enchantable(1)).build());
        } else {
            consumer.accept(components -> {
                Equippable equippable;
                if (!components.has(DataComponents.ENCHANTABLE) && (equippable = (Equippable)components.get(DataComponents.EQUIPPABLE)) != null && equippable.slot() == EquipmentSlot.BODY) {
                    ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)components.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
                    double defenseValue = itemAttributeModifiers.modifiers().stream().filter(entry -> entry.attribute().is(Attributes.ARMOR)).map(ItemAttributeModifiers.Entry::modifier).mapToDouble(AttributeModifier::amount).sum();
                    return DataComponentPatch.builder().set(DataComponents.ENCHANTABLE, (Object)new Enchantable(Math.max(1, Mth.ceil((double)defenseValue)))).build();
                }
                return DataComponentPatch.EMPTY;
            });
        }
    }

    public static void onTagsUpdated(HolderLookup.Provider registries, boolean client) {
        HolderLookup.RegistryLookup itemLookup = registries.lookupOrThrow(Registries.ITEM);
        HolderLookup.RegistryLookup enchantmentLookup = registries.lookupOrThrow(Registries.ENCHANTMENT);
        enchantmentLookup.listElements().forEach(holder -> {
            Enchantment enchantment = (Enchantment)holder.value();
            Enchantment.EnchantmentDefinition enchantmentDefinition = enchantment.definition();
            if (!enchantmentDefinition.slots().contains(EquipmentSlotGroup.BODY)) {
                for (EquipmentSlotGroup slot : enchantmentDefinition.slots()) {
                    if (!ARMOR_EQUIPMENT_SLOT_GROUPS.contains(slot)) continue;
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll((Iterable)enchantmentDefinition.slots());
                    builder.add((Object)EquipmentSlotGroup.BODY);
                    enchantmentDefinition.slots = builder.build();
                }
            }
            ItemCompatHandler.setEnchantmentProperty(enchantmentLookup, ModRegistry.getInclusiveSetEnchantmentTag((ResourceKey<Enchantment>)holder.key()), enchantment.exclusiveSet(), holderSet -> {
                enchantment.exclusiveSet = holderSet;
            }, CompositeHolderSet.Removal::new);
            ItemCompatHandler.setSupportedEnchantmentItems(itemLookup, ModRegistry.getSecondaryEnchantableItemTag((ResourceKey<Enchantment>)holder.key()), enchantmentDefinition.supportedItems(), holderSet -> {
                enchantmentDefinition.supportedItems = holderSet;
            });
            enchantmentDefinition.primaryItems().ifPresent(holderSetX -> ItemCompatHandler.setSupportedEnchantmentItems(itemLookup, ModRegistry.getPrimaryEnchantableItemTag((ResourceKey<Enchantment>)holder.key()), holderSetX, holderSet -> {
                enchantmentDefinition.primaryItems = Optional.of(holderSet);
            }));
        });
    }

    private static <T> void setSupportedEnchantmentItems(HolderLookup.RegistryLookup<T> registryLookup, TagKey<T> tagKey, HolderSet<T> supportedItems, Consumer<HolderSet<T>> holderSetSetter) {
        ItemCompatHandler.setEnchantmentProperty(registryLookup, tagKey, supportedItems, holderSetSetter, (o1, o2) -> new CompositeHolderSet.Or(List.of(o1, o2)));
    }

    private static <T> void setEnchantmentProperty(HolderLookup.RegistryLookup<T> registryLookup, TagKey<T> tagKey, HolderSet<T> originalHolderSet, Consumer<HolderSet<T>> holderSetSetter, BinaryOperator<HolderSet<T>> holderSetCombiner) {
        Optional optional = registryLookup.get(tagKey);
        HolderSet newHolderSet = optional.map(holderSetX -> holderSetX).orElse(HolderSet.empty());
        holderSetSetter.accept((HolderSet)holderSetCombiner.apply(originalHolderSet, newHolderSet));
    }

    public static EventResult onShieldBlock(LivingEntity blockingEntity, DamageSource damageSource, MutableFloat blockedDamage) {
        Level level = blockingEntity.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (damageSource.isDirect() && (entity = damageSource.getEntity()) instanceof LivingEntity) {
                LivingEntity attackingEntity = (LivingEntity)entity;
                if (IS_BLOCKING_WITH_SHIELD.get() == null) {
                    IS_BLOCKING_WITH_SHIELD.set(Unit.INSTANCE);
                    ItemCompatHandler.doPostAttackEffectsWithItemSource(serverLevel, (Entity)attackingEntity, damageSource, blockingEntity.getUseItem());
                    float attackKnockback = (float)blockingEntity.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
                    attackKnockback = EnchantmentHelper.modifyKnockback((ServerLevel)serverLevel, (ItemStack)blockingEntity.getUseItem(), (Entity)attackingEntity, (DamageSource)damageSource, (float)attackKnockback);
                    attackingEntity.knockback(0.5 * (double)attackKnockback, blockingEntity.getX() - attackingEntity.getX(), blockingEntity.getZ() - attackingEntity.getZ());
                    IS_BLOCKING_WITH_SHIELD.remove();
                }
            }
        }
        return EventResult.PASS;
    }

    public static void doPostAttackEffectsWithItemSource(ServerLevel serverLevel, Entity entity, DamageSource damageSource, @Nullable ItemStack itemSource) {
        if (itemSource != null && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EnchantmentHelper.runIterationOnItem((ItemStack)itemSource, (EquipmentSlot)EquipmentSlot.MAINHAND, (LivingEntity)livingEntity, (holder, enchantmentLevel, enchantedItemInUse) -> ((Enchantment)holder.value()).doPostAttack(serverLevel, enchantmentLevel, enchantedItemInUse, EnchantmentTarget.VICTIM, entity, damageSource));
        }
        EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)entity, (DamageSource)damageSource, (ItemStack)itemSource);
    }

    public static EventResult onUseItemTick(LivingEntity entity, ItemStack useItem, MutableInt useItemRemaining) {
        Item item = useItem.getItem();
        int itemUseDuration = useItem.getUseDuration(entity) - useItemRemaining.getAsInt();
        if (item instanceof BowItem && itemUseDuration < 20 || item instanceof TridentItem && itemUseDuration < 10) {
            float chargingTime = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)useItem, (LivingEntity)entity, (float)1.25f);
            useItemRemaining.mapInt(duration -> duration - Mth.floor((float)((1.25f - chargingTime) / 0.25f)));
        }
        return EventResult.PASS;
    }
}

