/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.api.item.v2.EnchantingHelper;
import fuzs.universalenchants.UniversalEnchants;
import fuzs.universalenchants.config.ServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BetterEnchantsHandler {
    public static void onPickProjectile(LivingEntity livingEntity, ItemStack weaponItemStack, MutableValue<ItemStack> projectileItemStack) {
        if (!((ServerConfig)UniversalEnchants.CONFIG.get(ServerConfig.class)).trueInfinity) {
            return;
        }
        Level level = livingEntity.level();
        if (level instanceof ServerLevel) {
            ItemStack itemStack;
            ServerLevel serverLevel = (ServerLevel)level;
            if (((ItemStack)projectileItemStack.get()).isEmpty() && EnchantmentHelper.processAmmoUse((ServerLevel)serverLevel, (ItemStack)weaponItemStack, (ItemStack)(itemStack = new ItemStack((ItemLike)Items.ARROW)), (int)1) == 0) {
                projectileItemStack.accept((Object)itemStack);
            }
        }
    }

    public static EventResult onLivingHurt(LivingEntity entity, DamageSource source, MutableFloat amount) {
        if (!((ServerConfig)UniversalEnchants.CONFIG.get(ServerConfig.class)).noProjectileImmunity) {
            return EventResult.PASS;
        }
        if (!(entity instanceof Player) && source.is(DamageTypeTags.IS_PROJECTILE)) {
            entity.invulnerableTime = 0;
        }
        return EventResult.PASS;
    }

    public static EventResult onFarmlandTrample(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, double fallDistance, Entity entity) {
        LivingEntity livingEntity;
        Holder enchantment;
        if (!((ServerConfig)UniversalEnchants.CONFIG.get(ServerConfig.class)).noFarmlandTrample) {
            return EventResult.PASS;
        }
        if (entity instanceof LivingEntity && EnchantmentHelper.getEnchantmentLevel((Holder)(enchantment = EnchantingHelper.lookup((Entity)(livingEntity = (LivingEntity)entity), (ResourceKey)Enchantments.FEATHER_FALLING)), (LivingEntity)livingEntity) > 0) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingExperienceDrop(LivingEntity entity, @Nullable Player attackingPlayer, MutableInt droppedExperience) {
        int enchantmentLevel;
        if (!((ServerConfig)UniversalEnchants.CONFIG.get(ServerConfig.class)).lootBonusBoostsXp) {
            return EventResult.PASS;
        }
        if (attackingPlayer != null && (enchantmentLevel = EnchantingHelper.getEnchantmentLevel((ResourceKey)Enchantments.LOOTING, (LivingEntity)attackingPlayer)) > 0) {
            droppedExperience.mapInt(value -> BetterEnchantsHandler.getDroppedXp(value, enchantmentLevel));
        }
        return EventResult.PASS;
    }

    public static void onDropExperience(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, Player player, ItemStack itemInHand, MutableInt experienceToDrop) {
        if (!((ServerConfig)UniversalEnchants.CONFIG.get(ServerConfig.class)).lootBonusBoostsXp) {
            return;
        }
        Holder enchantment = EnchantingHelper.lookup((LevelReader)serverLevel, (ResourceKey)Enchantments.FORTUNE);
        int enchantmentLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantment, (ItemStack)itemInHand);
        if (enchantmentLevel > 0) {
            experienceToDrop.mapInt(value -> BetterEnchantsHandler.getDroppedXp(value, enchantmentLevel));
        }
    }

    private static int getDroppedXp(int originalExperience, int enchantmentLevel) {
        float experienceMultiplier = (float)(enchantmentLevel * (enchantmentLevel + 1)) / 10.0f;
        return originalExperience + Math.min(50, (int)Math.floor((float)originalExperience * experienceMultiplier));
    }
}

