PalladiumEvents.registerAnimations((event) => {
  event.register('gax_classic/block', 15, (builder) => {
    let block_anim = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'gax_classic:enhanced_chimera_sui_generis', 'block_ability', builder.getPartialTicks());
      if (block_anim > 0 && !builder.isFirstPerson()) {
        builder.get('right_arm')
          .setXRotDegrees(-80)
          .setYRotDegrees(-10)
          .setZRotDegrees(-80)
          .setX(builder.getModel().rightArm.x+1)
          .setY(builder.getModel().rightArm.y+0)
          .setZ(builder.getModel().rightArm.z-0)
          .animate('InOutCubic', block_anim);
        builder.get('left_arm')
          .setXRotDegrees(-80)
          .setYRotDegrees(10)
          .setZRotDegrees(80)
          .setX(builder.getModel().leftArm.x-1)
          .setY(builder.getModel().leftArm.y+0)
          .setZ(builder.getModel().leftArm.z-0)
          .animate('InOutCubic', block_anim);
        }
      if (block_anim > 0.0 && builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(20).setYRotDegrees(30).setZRotDegrees(40).setY(5).setX(0).setZ(-5).animate('InOutCubic', block_anim);
            builder.get('left_arm').setXRotDegrees(20).setYRotDegrees(-30).setZRotDegrees(-40).setY(5).setZ(-5).animate('InOutCubic', block_anim);
          } else {
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
  event.register('alienevo/charge_leap', 200, (builder) => {
    let charge_leap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'gax_classic:enhanced_chimera_sui_generis', 'leap_charge', builder.getPartialTicks());
      if (!palladium.abilities.isEnabled(builder.getPlayer(), 'gax_classic:enhanced_chimera_sui_generis', 'leap_charge')) {
        charge_leap = 0;
      }
      if (charge_leap > 0 && !builder.isFirstPerson()) {
        builder.get('head')
          .setY(builder.getModel().head.y+2)
          .animate('easeOutQuint', charge_leap);
        builder.get('chest')
          .setXRotDegrees(15)
          .setY(builder.getModel().body.y+2)
          .animate('easeOutQuint', charge_leap);
        builder.get('left_arm')
          .setXRotDegrees(120)
          .setY(builder.getModel().leftArm.y+3)
          .setZ(builder.getModel().leftArm.z+2)
          .animate('easeOutQuint', charge_leap);
        builder.get('right_arm')
          .setXRotDegrees(120)
          .setY(builder.getModel().rightArm.y+3)
          .setZ(builder.getModel().rightArm.z+2)
          .animate('easeOutQuint', charge_leap);
        builder.get('right_leg')
          .rotateX(builder.getModel().rightLeg.xRot * -0.5)
          .setZ(builder.getModel().rightLeg.z+4.5)
          .animate('easeOutQuint', charge_leap);  
        builder.get('left_leg')
          .rotateX(builder.getModel().leftLeg.xRot * -0.5)
          .setZ(builder.getModel().leftLeg.z+2)
          .animate('easeOutQuint', charge_leap);    
        }
      if (charge_leap > 0.0 && builder.isFirstPerson()) {
            builder.get('chest')
              .animate('easeInOutCirc', charge_leap);
                }
            });
          });       
PalladiumEvents.registerAnimations((event) => {
  event.register('leap/anim', 201, (builder) => {
    let leap_anim = animationUtil.getAnimationTimerAbilityValue(
      builder.getPlayer(), 'alienevo_aliens:enhanced_chimera_sui_generis', 'leap_anim', builder.getPartialTicks(), 1, 8);
        builder.get('left_arm')
          .animate('easeInOutCubic', leap_anim);
      if (leap_anim > 0.0 && builder.isFirstPerson()) {
        builder.get('chest')
          .animate('easeInOutCubic', leap_anim);
        }   
      if (abilityUtil.isEnabled(builder.getPlayer(), "gax_classic:tetramand", "leap_anim")) {
        leap_anim = animationUtil.getAnimationTimerAbilityValue(
          builder.getPlayer(), 'gax_classic:enhanced_chimera_sui_generis', 'leap_anim', builder.getPartialTicks(), 1, 16);
            if (leap_anim > 0.0 && !builder.isFirstPerson()) {
              builder.get('left_arm')
                .setXRotDegrees(-150)
                .setZ(builder.getModel().leftArm.z-1.5)
                .animate('easeOutCirc', leap_anim);
              builder.get('right_arm')
                .setXRotDegrees(-150)
                .setZ(builder.getModel().rightArm.z-1.5)
                .animate('easeOutCirc', leap_anim);
              builder.get('left_leg')
                .setXRotDegrees(25)
                .animate('easeOutCirc', leap_anim);
              builder.get('right_leg')
                .setXRotDegrees(25)
                .animate('easeOutCirc', leap_anim);
              builder.get('chest')
                .animate('easeOutQuint', leap_anim);
          }
        }
    });
});