/*
 * Decompiled with CFR 0.152.
 */
package lanse.copperworld;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import lanse.copperworld.CopperWorld;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class ChunkProcessor {
    public static final Set<class_1923> processedChunksOverworld = new HashSet<class_1923>();
    public static final Set<class_1923> processedChunksNether = new HashSet<class_1923>();
    public static final Set<class_1923> processedChunksEnd = new HashSet<class_1923>();
    public static int processedChunkCount = 0;
    public static int MAX_RENDER_DIST = 8;
    public static boolean complete = false;
    public static boolean overworldIsDisabled = false;
    public static boolean netherIsDisabled = false;
    public static boolean endIsDisabled = false;

    public static void tryNewChunks(MinecraftServer server, boolean repeat) {
        complete = true;
        block0: for (class_3222 player : server.method_3760().method_14571()) {
            class_3218 world = player.method_51469();
            class_1923 playerChunkPos = player.method_31476();
            class_5321 dimensionKey = world.method_27983();
            if (dimensionKey.equals(class_1937.field_25179) && overworldIsDisabled || dimensionKey.equals(class_1937.field_25180) && netherIsDisabled || dimensionKey.equals(class_1937.field_25181) && endIsDisabled || dimensionKey.equals(class_1937.field_25181) && (Math.abs(player.method_23317()) > 500.0 || Math.abs(player.method_23321()) > 500.0)) continue;
            ArrayList<class_2791> nearbyChunks = new ArrayList<class_2791>();
            int radius = 1;
            for (int i = 1; i < MAX_RENDER_DIST; ++i) {
                for (int dx = -radius; dx <= radius; ++dx) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        class_1923 chunkPos = new class_1923(playerChunkPos.field_9181 + dx, playerChunkPos.field_9180 + dz);
                        class_2791 chunk = world.method_14178().method_12121(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
                        if (chunk == null) continue;
                        if (world.method_27983().equals(class_1937.field_25179)) {
                            if (processedChunksOverworld.contains(chunkPos)) continue;
                            nearbyChunks.add(chunk);
                            complete = false;
                            if (repeat) continue;
                            ChunkProcessor.processChunk(world, chunk, false);
                            return;
                        }
                        if (world.method_27983().equals(class_1937.field_25180)) {
                            if (processedChunksNether.contains(chunkPos)) continue;
                            nearbyChunks.add(chunk);
                            complete = false;
                            if (repeat) continue;
                            ChunkProcessor.processChunk(world, chunk, false);
                            return;
                        }
                        if (!world.method_27983().equals(class_1937.field_25181) || processedChunksEnd.contains(chunkPos)) continue;
                        nearbyChunks.add(chunk);
                        complete = false;
                        if (repeat) continue;
                        ChunkProcessor.processChunk(world, chunk, false);
                        return;
                    }
                }
                if (nearbyChunks.size() < 25) {
                    ++radius;
                    continue;
                }
                for (class_2791 chunk : nearbyChunks) {
                    ChunkProcessor.processChunk(world, chunk, true);
                }
                continue block0;
            }
        }
    }

    private static void processChunk(class_3218 world, class_2791 chunk, boolean fullQueue) {
        class_1923 chunkPos = chunk.method_12004();
        ++processedChunkCount;
        if (world.method_27983().equals(class_1937.field_25179)) {
            if (processedChunksOverworld.contains(chunkPos)) {
                return;
            }
            processedChunksOverworld.add(chunkPos);
        } else if (world.method_27983().equals(class_1937.field_25180)) {
            if (processedChunksNether.contains(chunkPos)) {
                return;
            }
            processedChunksNether.add(chunkPos);
        } else if (world.method_27983().equals(class_1937.field_25181)) {
            if (processedChunksEnd.contains(chunkPos)) {
                return;
            }
            processedChunksEnd.add(chunkPos);
        }
        if (fullQueue) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int worldX = chunkPos.method_8326() + x;
                    int worldZ = chunkPos.method_8328() + z;
                    CopperWorld.processingQueue.add(new CopperWorld.ChunkTask(world, worldX, worldZ));
                }
            }
        } else {
            int worldX = chunkPos.method_8326();
            int worldZ = chunkPos.method_8328();
            CopperWorld.processingQueue.add(new CopperWorld.ChunkTask(world, worldX, worldZ));
        }
    }

    public static void clearProcessedChunks() {
        CopperWorld.processingQueue.clear();
        processedChunksOverworld.clear();
        processedChunksNether.clear();
        processedChunksEnd.clear();
        processedChunkCount = 0;
        complete = false;
    }
}

