/*
 * Decompiled with CFR 0.152.
 */
package lanse.copperworld;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.nio.file.Path;
import lanse.copperworld.ChunkProcessor;
import lanse.copperworld.CopperWorld;
import lanse.copperworld.storage.Database;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class Commands {
    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"CopperWorld").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"on").executes(context -> {
            CopperWorld.originalServer = ((class_2168)context.getSource()).method_9211();
            CopperWorld.originalPlayer = ((class_2168)context.getSource()).method_44023();
            CopperWorld.isModEnabled = true;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"CopperWorld Enabled!"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"off").executes(context -> {
            CopperWorld.isModEnabled = false;
            Database dataSaver = Database.getOrCreate(((class_2168)context.getSource()).method_9211());
            Path configFolder = CopperWorld.getConfigFolder();
            dataSaver.saveToJson(configFolder);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"CopperWorld Disabled!"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"saveAll").executes(context -> {
            Database dataSaver = Database.getOrCreate(((class_2168)context.getSource()).method_9211());
            Path configFolder = CopperWorld.getConfigFolder();
            dataSaver.saveToJson(configFolder);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"CopperWorld Settings and Region File Saved!"), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").then(class_2170.method_9247((String)"chunks").executes(context -> {
            ChunkProcessor.clearProcessedChunks();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"CopperWorld processing queue and updated chunks reset!"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"settings").then(class_2170.method_9244((String)"confirm", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"confirm"}, (SuggestionsBuilder)builder)).executes(context -> {
            String confirmation = StringArgumentType.getString((CommandContext)context, (String)"confirm");
            if (!confirmation.equals("confirm")) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Type '/reset settings confirm' to proceed."), false);
                return 0;
            }
            Database.returnToDefaultValues();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"CopperWorld settings have returned to default!"), true);
            return 1;
        }))))).then(class_2170.method_9247((String)"Set").then(class_2170.method_9247((String)"setting").then(class_2170.method_9244((String)"setting", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"main_column_loading_speed", "main_render_distance"}, (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            String setting = StringArgumentType.getString((CommandContext)context, (String)"setting").toLowerCase();
            int value = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            Database.changed = true;
            switch (setting) {
                case "main_column_loading_speed": {
                    if (value >= 1 && value <= 3500) {
                        CopperWorld.maxColumnsPerTick = value;
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Column Loading Speed set to: " + value)), true);
                        if (value <= 1000) break;
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"BE CAREFUL WITH VALUES ABOVE 1,000 FOR THIS!!! THE GAME MIGHT CRASH ON SOME SETTINGS OR DEVICES!!!"), true);
                        break;
                    }
                    ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"Please specify a value between 1 and 3,500."));
                    break;
                }
                case "main_render_distance": {
                    if (value >= 2 && value <= 10000000) {
                        ChunkProcessor.MAX_RENDER_DIST = value;
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Render Transform Distance set to: " + value)), true);
                        break;
                    }
                    ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"Please specify a value between 2 and 10,000,000."));
                    break;
                }
                default: {
                    ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"Unknown setting."));
                }
            }
            return 1;
        }))))));
    }
}

