/*
 * Decompiled with CFR 0.152.
 */
package lanse.copperworld;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lanse.copperworld.ChunkProcessor;
import lanse.copperworld.Commands;
import lanse.copperworld.WorldEditor;
import lanse.copperworld.storage.Database;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class CopperWorld
implements ModInitializer {
    public static boolean isModEnabled = false;
    public static MinecraftServer originalServer;
    public static final Queue<ChunkTaskResult> editQueue;
    public static Queue<ChunkTask> processingQueue;
    public static int maxColumnsPerTick;
    public static int tickCount;
    public static class_3222 originalPlayer;
    private static final ExecutorService workerPool;

    public void onInitialize() {
        ServerTickEvents.START_SERVER_TICK.register(this::onServerTick);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> Commands.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        Path configFolder = CopperWorld.getConfigFolder();
        if (!Files.exists(configFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(configFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {}
        } else {
            try {
                this.loadConfigFromJson(configFolder);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void onServerTick(MinecraftServer server) {
        if (++tickCount > 0x7FFFFFF9) {
            tickCount = 0;
        }
        if (tickCount % 300 == 0 && Database.changed) {
            Database dataSaver = Database.getOrCreate(server);
            Path configFolder = CopperWorld.getConfigFolder();
            dataSaver.saveToJson(configFolder);
        }
        if (isModEnabled) {
            if (server != originalServer) {
                isModEnabled = false;
            }
            if (ChunkProcessor.processedChunkCount > 25000) {
                ChunkProcessor.clearProcessedChunks();
            }
            this.processQueuedChunks();
            if (!(processingQueue.size() >= maxColumnsPerTick * 20 || ChunkProcessor.complete && tickCount % 120 != 0)) {
                ChunkProcessor.tryNewChunks(server, true);
            }
        }
    }

    public void processQueuedChunks() {
        int processedCount = 0;
        ArrayList<Object> tasks = new ArrayList<Object>();
        while (!processingQueue.isEmpty() && processedCount < maxColumnsPerTick) {
            ChunkTask task = processingQueue.poll();
            if (task == null) continue;
            tasks.add(task);
            ++processedCount;
        }
        for (ChunkTask chunkTask : tasks) {
            workerPool.submit(() -> {
                boolean shouldProcess;
                ArrayList<BlockEdit> edits = new ArrayList<BlockEdit>();
                class_5321 dimensionKey = task.world.method_27983();
                switch (dimensionKey.method_29177().method_12832()) {
                    case "overworld": {
                        boolean bl = this.processOverworldColumn(task, edits);
                        break;
                    }
                    case "the_nether": {
                        boolean bl = this.processNetherColumn(task, edits);
                        break;
                    }
                    case "the_end": {
                        boolean bl = this.processEndColumn(task, edits);
                        break;
                    }
                    default: {
                        boolean bl = shouldProcess = false;
                    }
                }
                if (shouldProcess && !edits.isEmpty()) {
                    editQueue.add(new ChunkTaskResult(task.world, task.x, task.z, edits));
                }
            });
        }
        int applied = 0;
        while (!editQueue.isEmpty() && applied < maxColumnsPerTick * 100) {
            ChunkTaskResult chunkTaskResult = editQueue.poll();
            if (chunkTaskResult == null) continue;
            for (BlockEdit edit : chunkTaskResult.edits()) {
                class_2791 chunk = chunkTaskResult.world.method_22350(edit.pos());
                chunk.method_12010(edit.pos(), edit.state(), 0);
                chunkTaskResult.world.method_14178().method_14128(edit.pos());
            }
            ++applied;
        }
    }

    private boolean processOverworldColumn(ChunkTask task, List<BlockEdit> edits) {
        if (ChunkProcessor.overworldIsDisabled) {
            return false;
        }
        if (task.world.method_18456().stream().noneMatch(player -> player.method_51469() == task.world)) {
            return false;
        }
        WorldEditor.adjustColumn(task.world, task.x, task.z, edits);
        return true;
    }

    private boolean processNetherColumn(ChunkTask task, List<BlockEdit> edits) {
        if (ChunkProcessor.netherIsDisabled) {
            return false;
        }
        if (task.world.method_18456().stream().noneMatch(player -> player.method_51469() == task.world)) {
            return false;
        }
        WorldEditor.adjustColumn(task.world, task.x, task.z, edits);
        return true;
    }

    private boolean processEndColumn(ChunkTask task, List<BlockEdit> edits) {
        if (ChunkProcessor.endIsDisabled) {
            return false;
        }
        if (task.world.method_18456().stream().noneMatch(player -> player.method_51469() == task.world)) {
            return false;
        }
        WorldEditor.adjustColumn(task.world, task.x, task.z, edits);
        return true;
    }

    public static Path getConfigFolder() {
        return FabricLoader.getInstance().getGameDir().resolve("config/copperworld");
    }

    private void loadConfigFromJson(Path configFolder) throws IOException {
        Path configFile = configFolder.resolve("config.json");
        if (Files.exists(configFile, new LinkOption[0]) && Files.size(configFile) > 0L) {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                Gson gson = new Gson();
                JsonObject jsonConfig = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                Database.fromJson(jsonConfig);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        editQueue = new ConcurrentLinkedQueue<ChunkTaskResult>();
        processingQueue = new ConcurrentLinkedQueue<ChunkTask>();
        maxColumnsPerTick = 100;
        tickCount = 0;
        workerPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public record ChunkTask(class_3218 world, int x, int z) {
    }

    public record ChunkTaskResult(class_3218 world, int x, int z, List<BlockEdit> edits) {
    }

    public record BlockEdit(class_2338 pos, class_2680 state) {
    }
}

