/*
 * Decompiled with CFR 0.152.
 */
package lanse.copperworld.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lanse.copperworld.ChunkProcessor;
import lanse.copperworld.CopperWorld;
import net.minecraft.server.MinecraftServer;

public class Database {
    public static boolean changed = false;

    public static Database getOrCreate(MinecraftServer server) {
        Path configFolder = server.method_3831().resolve("config/copperworld");
        Path configFile = configFolder.resolve("config.json");
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                Files.createDirectories(configFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Database();
    }

    public void saveToJson(Path configFolder) {
        Path configFile = configFolder.resolve("config.json");
        try {
            if (Files.exists(configFile, new LinkOption[0])) {
                Files.delete(configFile);
            }
            Files.createFile(configFile, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                JsonObject jsonConfig = this.toJson();
                gson.toJson((JsonElement)jsonConfig, (Appendable)writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("maxRender", (Number)ChunkProcessor.MAX_RENDER_DIST);
        json.addProperty("overworldIsDisabled", Boolean.valueOf(ChunkProcessor.overworldIsDisabled));
        json.addProperty("netherIsDisabled", Boolean.valueOf(ChunkProcessor.netherIsDisabled));
        json.addProperty("endIsDisabled", Boolean.valueOf(ChunkProcessor.endIsDisabled));
        json.addProperty("maxColumnsPerTick", (Number)CopperWorld.maxColumnsPerTick);
        changed = false;
        return json;
    }

    public static void fromJson(JsonObject json) {
        ChunkProcessor.MAX_RENDER_DIST = Database.getInt(json, "maxRender", 8);
        ChunkProcessor.overworldIsDisabled = Database.getBoolean(json, "overworldIsDisabled", false);
        ChunkProcessor.overworldIsDisabled = Database.getBoolean(json, "netherIsDisabled", false);
        ChunkProcessor.overworldIsDisabled = Database.getBoolean(json, "endIsDisabled", false);
        CopperWorld.maxColumnsPerTick = Database.getInt(json, "maxColumnsPerTick", 100);
    }

    public static void returnToDefaultValues() {
        CopperWorld.isModEnabled = false;
        ChunkProcessor.MAX_RENDER_DIST = 8;
        ChunkProcessor.overworldIsDisabled = false;
        ChunkProcessor.netherIsDisabled = false;
        ChunkProcessor.endIsDisabled = false;
        CopperWorld.maxColumnsPerTick = 100;
    }

    private static int getInt(JsonObject json, String key, int defaultValue) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsInt() : defaultValue;
    }

    private static boolean getBoolean(JsonObject json, String key, boolean defaultValue) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsBoolean() : defaultValue;
    }

    private static double getDouble(JsonObject json, String key, double defaultValue) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsDouble() : defaultValue;
    }

    private static String getString(JsonObject json, String key, String defaultValue) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : defaultValue;
    }
}

