/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.client.renderer.block.model;

import com.mojang.math.Quadrant;
import fuzs.puzzleslib.api.client.renderer.v1.model.QuadUtils;
import fuzs.spikyspikes.SpikySpikes;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SpikeModelGenerator
implements UnbakedModel {
    public static final ResourceLocation BUILTIN_SPIKE_MODEL = SpikySpikes.id("builtin/spike");
    public static final TextureSlots.Data TEXTURE_SLOTS = new TextureSlots.Data.Builder().addTexture(Direction.UP.getSerializedName(), new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation())).build();
    private static final List<BlockElement> ELEMENTS = Collections.singletonList(SpikeModelGenerator.createCubeElement());

    public TextureSlots.Data textureSlots() {
        return TEXTURE_SLOTS;
    }

    public UnbakedGeometry geometry() {
        return SpikeModelGenerator::bake;
    }

    private static BlockElement createCubeElement() {
        BlockElementFace.UVs blockFaceUV = new BlockElementFace.UVs(0.0f, 0.0f, 16.0f, 16.0f);
        EnumMap<Direction, BlockElementFace> map = new EnumMap<Direction, BlockElementFace>(Direction.class);
        for (Direction direction : Direction.values()) {
            map.put(direction, new BlockElementFace(direction, -1, direction.getSerializedName(), blockFaceUV, Quadrant.R0));
        }
        return new BlockElement((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(16.0f, 16.0f, 16.0f), map);
    }

    public static QuadCollection bake(TextureSlots textureSlots, ModelBaker modelBaker, ModelState modelState, ModelDebugName modelDebugName) {
        QuadCollection quadCollection = SimpleUnbakedGeometry.bake(ELEMENTS, (TextureSlots)textureSlots, (SpriteGetter)modelBaker.sprites(), (ModelState)modelState, (ModelDebugName)modelDebugName);
        return SpikeModelGenerator.modifyBakedModel(quadCollection, modelState, SpikeModelGenerator::finalizeBakedQuad);
    }

    private static QuadCollection modifyBakedModel(QuadCollection quadCollection, ModelState modelState, BakedQuadFinalizer bakedQuadFinalizer) {
        Map bakedQuadMap = Util.makeEnumMap(Direction.class, direction -> (BakedQuad)quadCollection.getQuads(direction).getFirst());
        QuadCollection.Builder builder = new QuadCollection.Builder();
        for (BakedQuad bakedQuad2 : quadCollection.getQuads(null)) {
            builder.addUnculledFace(bakedQuad2);
        }
        Function directionRotator = Util.memoize(direction -> Direction.rotate((Matrix4fc)modelState.transformation().getMatrix(), (Direction)direction));
        for (Map.Entry entry : bakedQuadMap.entrySet()) {
            bakedQuadFinalizer.finalizeBakedQuad(Direction.rotate((Matrix4fc)modelState.transformation().getMatrixCopy().invert(), (Direction)((Direction)entry.getKey())), (BakedQuad)entry.getValue(), directionRotator::apply, (direction, bakedQuad) -> {
                if (direction != null) {
                    builder.addCulledFace(direction, bakedQuad);
                } else {
                    builder.addUnculledFace(bakedQuad);
                }
            });
        }
        return builder.build();
    }

    private static void finalizeBakedQuad(Direction direction, BakedQuad bakedQuad, UnaryOperator<Direction> directionRotator, BiConsumer<@Nullable Direction, BakedQuad> bakedQuadConsumer) {
        if (direction != Direction.UP) {
            bakedQuad = QuadUtils.copy((BakedQuad)bakedQuad);
            if (direction.getAxis().isHorizontal()) {
                int[] maxVertexIndices = ((Direction)directionRotator.apply(Direction.UP)).getAxisDirection() == Direction.UP.getAxisDirection() ? SpikeModelGenerator.getMaxVertexIndices(bakedQuad, ((Direction)directionRotator.apply(Direction.UP)).getAxis()) : SpikeModelGenerator.getMinVertexIndices(bakedQuad, ((Direction)directionRotator.apply(Direction.UP)).getAxis());
                for (int vertexIndex : maxVertexIndices) {
                    SpikeModelGenerator.setQuadPosition(bakedQuad, vertexIndex, ((Direction)directionRotator.apply(Direction.EAST)).getAxis(), 0.5f);
                    SpikeModelGenerator.setQuadPosition(bakedQuad, vertexIndex, ((Direction)directionRotator.apply(Direction.SOUTH)).getAxis(), 0.5f);
                    float u0 = QuadUtils.getU((BakedQuad)bakedQuad, (int)maxVertexIndices[0]);
                    float u1 = QuadUtils.getU((BakedQuad)bakedQuad, (int)maxVertexIndices[1]);
                    QuadUtils.setU((BakedQuad)bakedQuad, (int)vertexIndex, (float)Mth.lerp((float)0.5f, (float)u0, (float)u1));
                }
                QuadUtils.fillNormal((BakedQuad)bakedQuad);
                bakedQuadConsumer.accept(null, bakedQuad);
            } else {
                bakedQuadConsumer.accept((Direction)directionRotator.apply(direction), bakedQuad);
            }
        }
    }

    public static int[] getMaxVertexIndices(BakedQuad bakedQuad, Direction.Axis axis) {
        IntArrayList maxVertexIndices = new IntArrayList();
        float maxValue = Float.MIN_VALUE;
        for (int i = 0; i < 4; ++i) {
            float positionComponent = SpikeModelGenerator.getQuadPosition(bakedQuad, i, axis);
            if (positionComponent > maxValue) {
                maxVertexIndices.clear();
                maxValue = positionComponent;
            }
            if (positionComponent != maxValue) continue;
            maxVertexIndices.add(i);
        }
        return maxVertexIndices.toIntArray();
    }

    public static int[] getMinVertexIndices(BakedQuad bakedQuad, Direction.Axis axis) {
        IntArrayList minVertexIndices = new IntArrayList();
        float minValue = Float.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            float positionComponent = SpikeModelGenerator.getQuadPosition(bakedQuad, i, axis);
            if (positionComponent < minValue) {
                minVertexIndices.clear();
                minValue = positionComponent;
            }
            if (positionComponent != minValue) continue;
            minVertexIndices.add(i);
        }
        return minVertexIndices.toIntArray();
    }

    public static float getQuadPosition(BakedQuad bakedQuad, int vertexIndex, Direction.Axis axis) {
        Vector3f vector3f = QuadUtils.getPosition((BakedQuad)bakedQuad, (int)vertexIndex);
        return (float)axis.choose((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z());
    }

    public static void setQuadPosition(BakedQuad bakedQuad, int vertexIndex, Direction.Axis axis, float positionComponent) {
        Vector3f vector3f = QuadUtils.getPosition((BakedQuad)bakedQuad, (int)vertexIndex);
        vector3f.sub((Vector3fc)vector3f.mul((Vector3fc)axis.getPositive().step(), new Vector3f()));
        QuadUtils.setPosition((BakedQuad)bakedQuad, (int)vertexIndex, (Vector3f)vector3f.add((Vector3fc)axis.getPositive().step().mul(positionComponent)));
    }

    @FunctionalInterface
    public static interface BakedQuadFinalizer {
        public void finalizeBakedQuad(Direction var1, BakedQuad var2, UnaryOperator<Direction> var3, BiConsumer<@Nullable Direction, BakedQuad> var4);
    }
}

