/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.init;

import fuzs.puzzleslib.api.data.v2.AbstractDatapackRegistriesProvider;
import fuzs.puzzleslib.api.init.v3.registry.ContentRegistrationHelper;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import fuzs.puzzleslib.api.init.v3.tags.TagFactory;
import fuzs.spikyspikes.world.item.SpikeItem;
import fuzs.spikyspikes.world.level.block.SpikeBlock;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import fuzs.spikyspikes.world.level.block.entity.SpikeBlockEntity;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class ModRegistry {
    public static final RegistrySetBuilder REGISTRY_SET_BUILDER = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, ModRegistry::bootstrapDamageTypes);
    static final RegistryManager REGISTRIES = RegistryManager.from((String)"spikyspikes");
    public static final Holder.Reference<Block> WOODEN_SPIKE_BLOCK = ((RegistryManager)REGISTRIES.whenOnFabricLike()).registerBlock("wooden_spike", properties -> new SpikeBlock(SpikeMaterial.WOOD, (BlockBehaviour.Properties)properties), ModRegistry::woodenSpikeProperties);
    public static final Holder.Reference<Block> STONE_SPIKE_BLOCK = ((RegistryManager)REGISTRIES.whenOnFabricLike()).registerBlock("stone_spike", properties -> new SpikeBlock(SpikeMaterial.STONE, (BlockBehaviour.Properties)properties), ModRegistry::stoneSpikeProperties);
    public static final Holder.Reference<Block> IRON_SPIKE_BLOCK = ((RegistryManager)REGISTRIES.whenOnFabricLike()).registerBlock("iron_spike", properties -> new SpikeBlock(SpikeMaterial.IRON, (BlockBehaviour.Properties)properties), ModRegistry::ironSpikeProperties);
    public static final Holder.Reference<Block> GOLDEN_SPIKE_BLOCK = ((RegistryManager)REGISTRIES.whenOnFabricLike()).registerBlock("golden_spike", properties -> new SpikeBlock(SpikeMaterial.GOLD, (BlockBehaviour.Properties)properties), ModRegistry::goldenSpikeProperties);
    public static final Holder.Reference<Block> DIAMOND_SPIKE_BLOCK = ((RegistryManager)REGISTRIES.whenOnFabricLike()).registerBlock("diamond_spike", properties -> new SpikeBlock(SpikeMaterial.DIAMOND, (BlockBehaviour.Properties)properties), ModRegistry::diamondSpikeProperties);
    public static final Holder.Reference<Block> NETHERITE_SPIKE_BLOCK = ((RegistryManager)REGISTRIES.whenOnFabricLike()).registerBlock("netherite_spike", properties -> new SpikeBlock(SpikeMaterial.NETHERITE, (BlockBehaviour.Properties)properties), ModRegistry::netheriteSpikeProperties);
    public static final Holder.Reference<Item> WOODEN_SPIKE_ITEM = REGISTRIES.registerBlockItem(WOODEN_SPIKE_BLOCK, SpikeItem::new, Item.Properties::new);
    public static final Holder.Reference<Item> STONE_SPIKE_ITEM = REGISTRIES.registerBlockItem(STONE_SPIKE_BLOCK, SpikeItem::new, Item.Properties::new);
    public static final Holder.Reference<Item> IRON_SPIKE_ITEM = REGISTRIES.registerBlockItem(IRON_SPIKE_BLOCK, SpikeItem::new, Item.Properties::new);
    public static final Holder.Reference<Item> GOLDEN_SPIKE_ITEM = REGISTRIES.registerBlockItem(GOLDEN_SPIKE_BLOCK, SpikeItem::new, Item.Properties::new);
    public static final Holder.Reference<Item> DIAMOND_SPIKE_ITEM = REGISTRIES.registerBlockItem(DIAMOND_SPIKE_BLOCK, SpikeItem::new, () -> new Item.Properties().component(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY).enchantable(1));
    public static final Holder.Reference<Item> NETHERITE_SPIKE_ITEM = REGISTRIES.registerBlockItem(NETHERITE_SPIKE_BLOCK, SpikeItem::new, () -> new Item.Properties().component(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY).enchantable(1));
    public static final Holder.Reference<CreativeModeTab> CREATIVE_MODE_TAB = REGISTRIES.registerCreativeModeTab(DIAMOND_SPIKE_ITEM);
    public static final Holder.Reference<BlockEntityType<SpikeBlockEntity>> SPIKE_BLOCK_ENTITY_TYPE = REGISTRIES.registerBlockEntityType("spike", SpikeBlockEntity::new, () -> Set.of((Block)WOODEN_SPIKE_BLOCK.value(), (Block)STONE_SPIKE_BLOCK.value(), (Block)IRON_SPIKE_BLOCK.value(), (Block)GOLDEN_SPIKE_BLOCK.value(), (Block)DIAMOND_SPIKE_BLOCK.value(), (Block)NETHERITE_SPIKE_BLOCK.value()));
    public static final ResourceKey<DamageType> SPIKE_DAMAGE_TYPE = REGISTRIES.registerDamageType("spike");
    static final TagFactory TAGS = TagFactory.make((String)"spikyspikes");
    public static final TagKey<EntityType<?>> SPIKE_DAMAGE_IMMUNE_ENTITY_TYPE_TAG = TAGS.registerEntityTypeTag("spike_damage_immune");

    public static void bootstrap() {
        ContentRegistrationHelper.registerTransmuteRecipeSerializers((RegistryManager)REGISTRIES);
    }

    public static void bootstrapDamageTypes(BootstrapContext<DamageType> context) {
        AbstractDatapackRegistriesProvider.registerDamageType(context, SPIKE_DAMAGE_TYPE);
    }

    public static BlockBehaviour.Properties woodenSpikeProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f, 3.0f).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties stoneSpikeProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(2.0f, 6.0f).pushReaction(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties ironSpikeProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties goldenSpikeProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties diamondSpikeProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties netheriteSpikeProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).sound(SoundType.NETHERITE_BLOCK).pushReaction(PushReaction.DESTROY);
    }
}

