/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.neoforge.client;

import com.google.gson.JsonElement;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.neoforge.api.data.v2.core.DataProviderHelper;
import fuzs.puzzleslib.neoforge.api.data.v2.core.NeoForgeDataProviderContext;
import fuzs.spikyspikes.client.SpikySpikesClient;
import fuzs.spikyspikes.client.renderer.block.model.SpikeModelGenerator;
import fuzs.spikyspikes.data.client.ModLanguageProvider;
import fuzs.spikyspikes.data.client.ModModelProvider;
import fuzs.spikyspikes.util.DestroyEffectsHelper;
import fuzs.spikyspikes.world.level.block.SpikeBlock;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.model.DelegateUnbakedModel;

@Mod(value="spikyspikes", dist={Dist.CLIENT})
public class SpikySpikesNeoForgeClient {
    public SpikySpikesNeoForgeClient(ModContainer modContainer) {
        ClientModConstructor.construct((String)"spikyspikes", SpikySpikesClient::new);
        SpikySpikesNeoForgeClient.registerLoadingHandlers(modContainer.getEventBus());
        DataProviderHelper.registerDataProviders((String)"spikyspikes", (NeoForgeDataProviderContext.Factory[])new NeoForgeDataProviderContext.Factory[]{ModLanguageProvider::new, ModModelProvider::new});
    }

    private static void registerLoadingHandlers(IEventBus eventBus) {
        eventBus.addListener(event -> event.register(SpikeModelGenerator.BUILTIN_SPIKE_MODEL, (jsonObject, context) -> {
            jsonObject.remove("loader");
            return new DelegateUnbakedModel((UnbakedModel)context.deserialize((JsonElement)jsonObject, UnbakedModel.class)){

                public TextureSlots.Data textureSlots() {
                    return SpikeModelGenerator.TEXTURE_SLOTS;
                }

                public UnbakedGeometry geometry() {
                    return SpikeModelGenerator::bake;
                }
            };
        }));
        eventBus.addListener(event -> {
            for (Block block : BuiltInRegistries.BLOCK) {
                if (!(block instanceof SpikeBlock)) continue;
                event.registerBlock(new IClientBlockExtensions(){

                    public boolean addDestroyEffects(BlockState blockState, Level level, BlockPos blockPos, ParticleEngine particleEngine) {
                        return DestroyEffectsHelper.addDestroyEffects(blockState, level, blockPos, particleEngine) || super.addDestroyEffects(blockState, level, blockPos, particleEngine);
                    }
                }, new Block[]{block});
            }
        });
    }
}

