/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block.entity;

import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import fuzs.spikyspikes.init.ModRegistry;
import fuzs.spikyspikes.world.damagesource.SpikeDamageSource;
import fuzs.spikyspikes.world.level.block.entity.BlockEnchantmentHelper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;

public final class FakePlayerAttackHelper {
    private FakePlayerAttackHelper() {
    }

    public static void attack(Entity entity, ServerLevel serverLevel, BlockPos pos, Direction direction, float attackDamage, ItemEnchantments itemEnchantments, boolean hurtPlayers) {
        if (entity.isAttackable()) {
            DamageSource damageSource = SpikeDamageSource.source(ModRegistry.SPIKE_DAMAGE_TYPE, (Level)serverLevel, pos, itemEnchantments);
            float enchantedDamage = BlockEnchantmentHelper.modifyDamage(serverLevel, entity, damageSource, attackDamage, itemEnchantments) - attackDamage;
            if (attackDamage > 0.0f || enchantedDamage > 0.0f) {
                attackDamage += enchantedDamage;
                boolean setOnFire = false;
                if (entity instanceof LivingEntity && itemEnchantments.keySet().stream().anyMatch(holder -> holder.is(EnchantmentTags.SMELTS_LOOT)) && !entity.isOnFire()) {
                    setOnFire = true;
                    entity.igniteForSeconds(1.0f);
                }
                if (FakePlayerAttackHelper.hurt(serverLevel, entity, attackDamage, damageSource)) {
                    float attackKnockback = (float)BlockEnchantmentHelper.getAttributeValue((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, itemEnchantments);
                    attackKnockback = BlockEnchantmentHelper.modifyKnockback(serverLevel, entity, damageSource, attackKnockback, itemEnchantments);
                    FakePlayerAttackHelper.knockback(entity, attackKnockback * 0.5f, direction, serverLevel.getRandom());
                    FakePlayerAttackHelper.sweepAttack(entity, attackDamage, serverLevel, pos, direction, damageSource, hurtPlayers, itemEnchantments);
                    BlockEnchantmentHelper.doPostAttackEffects(serverLevel, entity, damageSource, itemEnchantments);
                    if (enchantedDamage > 0.0f) {
                        serverLevel.getChunkSource().sendToTrackingPlayersAndSelf(entity, (Packet)new ClientboundAnimatePacket(entity, 5));
                    }
                } else if (setOnFire) {
                    entity.clearFire();
                }
            }
        }
    }

    public static void knockback(Entity entity, double knockbackStrength, Direction direction, RandomSource random) {
        if (entity instanceof LivingEntity) {
            knockbackStrength *= 1.0 - ((LivingEntity)entity).getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
        }
        if (knockbackStrength > 0.0) {
            Vec3 deltaMovement = entity.getDeltaMovement();
            Vec3 normalVec = direction.getUnitVec3();
            int axisStep = direction.getOpposite().getAxisDirection().getStep();
            Vec3 offsetVec = new Vec3((double)axisStep, (double)axisStep, (double)axisStep).add(normalVec).multiply(random.nextGaussian(), random.nextGaussian(), random.nextGaussian());
            Vec3 knockbackVec = normalVec.add(offsetVec).normalize().scale(knockbackStrength);
            entity.setDeltaMovement(deltaMovement.x / 2.0 + knockbackVec.x, Math.min(0.4, deltaMovement.y / 2.0 + knockbackVec.y), deltaMovement.z / 2.0 + knockbackVec.z);
            entity.hasImpulse = true;
        }
    }

    public static boolean hurt(ServerLevel serverLevel, Entity entity, float attackDamage, DamageSource damageSource) {
        Vec3 oldMovement = entity.getDeltaMovement();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setLastHurtByMob(null);
            mob.setLastHurtByPlayer((EntityReference)null, 100);
            mob.setTarget(null);
        }
        if (entity.hurtServer(serverLevel, damageSource, attackDamage)) {
            entity.setDeltaMovement(oldMovement);
            return true;
        }
        return false;
    }

    public static void sweepAttack(Entity entity, float attackDamage, ServerLevel level, BlockPos pos, Direction direction, DamageSource damageSource, boolean hurtPlayers, ItemEnchantments itemEnchantments) {
        double sweepingDamageRatio = BlockEnchantmentHelper.getAttributeValue((Holder<Attribute>)Attributes.SWEEPING_DAMAGE_RATIO, itemEnchantments);
        if (sweepingDamageRatio != ((Attribute)Attributes.SWEEPING_DAMAGE_RATIO.value()).getDefaultValue()) {
            float sweepingDamage = 1.0f + (float)sweepingDamageRatio * attackDamage;
            Predicate<LivingEntity> filter = hurtPlayers ? EntitySelector.NO_SPECTATORS : Predicate.not(Player.class::isInstance);
            for (LivingEntity livingEntity : level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(1.0, 0.25, 1.0), filter)) {
                if (livingEntity == entity || livingEntity instanceof ArmorStand && ((ArmorStand)livingEntity).isMarker() || !(pos.distToCenterSqr((Position)livingEntity.position()) < 9.0)) continue;
                float hurtAmount = BlockEnchantmentHelper.modifyDamage(level, (Entity)livingEntity, damageSource, sweepingDamage, itemEnchantments);
                if (itemEnchantments.getLevel(LookupHelper.lookup((LevelReader)level, (ResourceKey)Registries.ENCHANTMENT, (ResourceKey)Enchantments.KNOCKBACK)) > 0) {
                    FakePlayerAttackHelper.knockback((Entity)livingEntity, 0.4f, direction, level.getRandom());
                }
                livingEntity.hurt(damageSource, hurtAmount);
                BlockEnchantmentHelper.doPostAttackEffects(level, (Entity)livingEntity, damageSource, itemEnchantments);
            }
            BlockPos onFrontPos = pos.relative(direction);
            level.playSound(null, (double)onFrontPos.getX() + 0.5, (double)onFrontPos.getY() + 0.5, (double)onFrontPos.getZ() + 0.5, SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, (double)onFrontPos.getX() + 0.5, (double)onFrontPos.getY() + 0.5, (double)onFrontPos.getZ() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

