/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.spikyspikes.init.ModRegistry;
import fuzs.spikyspikes.world.damagesource.SpikeDamageSource;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import fuzs.spikyspikes.world.level.block.entity.SpikeBlockEntity;
import fuzs.spikyspikes.world.phys.shapes.CustomOutlineShape;
import fuzs.spikyspikes.world.phys.shapes.VoxelUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_10583;
import net.minecraft.class_10774;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class SpikeBlock
extends class_2237
implements class_3737 {
    public static final MapCodec<SpikeBlock> CODEC = SpikeBlock.spikeCodec(SpikeBlock::new);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<class_2350> FACING = class_2741.field_12525;
    public static final class_2746 ENCHANTED = class_2746.method_11825((String)"enchanted");
    private static final Map<class_2350, class_265> SHAPE_BY_DIRECTION = (Map)Arrays.stream(class_2350.values()).collect(Maps.toImmutableEnumMap(Function.identity(), SpikeBlock::makeVisualShape));
    private static final Map<class_2350, class_265> COLLISION_SHAPE_BY_DIRECTION = (Map)Arrays.stream(class_2350.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> SpikeBlock.makeCollisionShape(direction, false)));
    private static final Map<class_2350, class_265> INTERACTION_SHAPE_BY_DIRECTION = (Map)Arrays.stream(class_2350.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> SpikeBlock.makeCollisionShape(direction, true)));
    private final SpikeMaterial spikeMaterial;

    public SpikeBlock(SpikeMaterial spikeMaterial, class_4970.class_2251 properties) {
        super(properties);
        this.spikeMaterial = spikeMaterial;
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE)).method_11657(FACING, (Comparable)class_2350.field_11036)).method_11657((class_2769)ENCHANTED, (Comparable)Boolean.FALSE));
    }

    protected static <T extends SpikeBlock> MapCodec<T> spikeCodec(BiFunction<SpikeMaterial, class_4970.class_2251, T> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpikeMaterial.CODEC.fieldOf("material").forGetter(SpikeBlock::getSpikeMaterial), (App)SpikeBlock.method_54096()).apply((Applicative)instance, factory));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public SpikeMaterial getSpikeMaterial() {
        return this.spikeMaterial;
    }

    protected class_2464 method_9604(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)ENCHANTED) != false ? class_2464.field_11455 : class_2464.field_11458;
    }

    private static class_265 makeVisualShape(class_2350 direction) {
        class_265 shape = SpikeBlock.makeStaircasePyramid(direction, 8, 2.0);
        class_243[] outlineVectors = VoxelUtils.makePyramidEdges(VoxelUtils.makeVectors(0.0, 0.0, 0.0, 16.0, 0.0, 0.0, 16.0, 0.0, 16.0, 0.0, 0.0, 16.0, 8.0, 16.0, 8.0));
        return new CustomOutlineShape(shape, VoxelUtils.scale(VoxelUtils.rotate(direction, outlineVectors)));
    }

    private static class_265 makeStaircasePyramid(class_2350 direction, int layers, double layerHeight) {
        class_243[] vectors = new class_243[layers * 2];
        int i = 0;
        int j = layers;
        while (i < layers) {
            vectors[2 * i] = new class_243(8.0 - (double)j, (double)i * layerHeight, 8.0 - (double)j);
            vectors[2 * i + 1] = new class_243(8.0 + (double)j, (double)(i + 1) * layerHeight, 8.0 + (double)j);
            ++i;
            --j;
        }
        return VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, vectors));
    }

    private static class_265 makeCollisionShape(class_2350 direction, boolean fullHeight) {
        class_243[] vectors = VoxelUtils.makeVectors(1.0, 0.0, 1.0, 15.0, fullHeight ? 16.0 : 11.0, 15.0);
        return VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, vectors));
    }

    public class_265 method_9530(class_2680 blockState, class_1922 level, class_2338 blockPos, class_3726 context) {
        return SHAPE_BY_DIRECTION.get(blockState.method_11654(FACING));
    }

    public class_265 method_9549(class_2680 blockState, class_1922 level, class_2338 blockPos, class_3726 context) {
        return COLLISION_SHAPE_BY_DIRECTION.get(blockState.method_11654(FACING));
    }

    public class_265 method_26159(class_2680 blockState, class_1922 level, class_2338 blockPos, class_3726 context) {
        return this.method_9530(blockState, level, blockPos, context);
    }

    public class_265 method_9584(class_2680 blockState, class_1922 level, class_2338 blockPos) {
        return INTERACTION_SHAPE_BY_DIRECTION.get(blockState.method_11654(FACING));
    }

    public class_265 method_25959(class_2680 blockState, class_1922 level, class_2338 blockPos) {
        return class_259.method_1073();
    }

    protected class_265 method_9571(class_2680 state) {
        return this.method_9604(state) != class_2464.field_11455 ? super.method_9571(state) : class_259.method_1073();
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654(FACING);
        class_2338 otherPos = pos.method_10093(direction.method_10153());
        if (direction == class_2350.field_11036) {
            return SpikeBlock.method_16361((class_1922)level, (class_2338)otherPos);
        }
        return level.method_8320(otherPos).method_26206((class_1922)level, otherPos, direction);
    }

    protected class_2680 method_9559(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborBlockPos, class_2680 neighborBlockState, class_5819 randomSource) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        return direction == ((class_2350)blockState.method_11654(FACING)).method_10153() && !this.method_9558(blockState, levelReader, blockPos) ? class_2246.field_10124.method_9564() : super.method_9559(blockState, levelReader, scheduledTickAccess, blockPos, direction, neighborBlockPos, neighborBlockState, randomSource);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2680 blockState = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(level.method_8316(blockPos).method_15772() == class_3612.field_15910))).method_11657((class_2769)ENCHANTED, (Comparable)Boolean.valueOf(!((class_9304)context.method_8041().method_58695(class_9334.field_49643, (Object)class_9304.field_49385)).method_57543()));
        for (class_2350 direction : context.method_7718()) {
            if (!(blockState = (class_2680)blockState.method_11657(FACING, (Comparable)direction.method_10153())).method_26184((class_4538)level, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public class_2680 method_9598(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)blockState.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 blockState, class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654(FACING)));
    }

    public class_3610 method_9545(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, FACING, ENCHANTED});
    }

    public boolean method_9516(class_2680 blockState, class_10 pathComputationType) {
        return false;
    }

    protected void method_9548(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity, class_10774 insideBlockEffectApplier, boolean intersectsPosition) {
        block10: {
            class_1309 livingEntity;
            class_3218 serverLevel;
            block11: {
                if (!(level instanceof class_3218)) break block10;
                serverLevel = (class_3218)level;
                if (!(entity instanceof class_1309) || !(livingEntity = (class_1309)entity).method_5805() || livingEntity.method_5864().method_20210(ModRegistry.SPIKE_DAMAGE_IMMUNE_ENTITY_TYPE_TAG)) break block10;
                if (!(livingEntity instanceof class_1657)) break block11;
                class_1657 player = (class_1657)livingEntity;
                if (player.method_31549().field_7477 || player.method_31549().field_7480) break block10;
            }
            if ((this.spikeMaterial.dealsFinalBlow() || livingEntity.method_6032() > this.spikeMaterial.damageAmount()) && (this.spikeMaterial.hurtsPlayers() || !(livingEntity instanceof class_1657))) {
                if (this.spikeMaterial.dropsPlayerLoot()) {
                    class_2586 class_25862 = level.method_8321(blockPos);
                    if (class_25862 instanceof SpikeBlockEntity) {
                        SpikeBlockEntity blockEntity = (SpikeBlockEntity)class_25862;
                        SpikeBlockEntity.attack(serverLevel, blockPos, level.method_8320(blockPos), blockEntity, livingEntity, this.spikeMaterial);
                    }
                } else {
                    boolean doMobLoot = serverLevel.method_64395().method_8355(class_1928.field_19391);
                    if (!this.spikeMaterial.dropsMobLoot()) {
                        ((class_1928.class_4310)serverLevel.method_64395().method_20746(class_1928.field_19391)).method_20758(false, level.method_8503());
                    }
                    livingEntity.method_64397(serverLevel, SpikeDamageSource.source(ModRegistry.SPIKE_DAMAGE_TYPE, level, blockPos), this.spikeMaterial.damageAmount());
                    if (!this.spikeMaterial.dropsMobLoot()) {
                        ((class_1928.class_4310)serverLevel.method_64395().method_20746(class_1928.field_19391)).method_20758(doMobLoot, level.method_8503());
                    }
                    if (!livingEntity.method_5805() && this.spikeMaterial.dropsExperience()) {
                        livingEntity.method_29505((class_10583)null, 100);
                        livingEntity.method_23883(serverLevel, null);
                        livingEntity.method_41329();
                    }
                }
            }
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SpikeBlockEntity(pos, state);
    }

    protected class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state, boolean includeData) {
        class_2586 class_25862;
        class_1799 itemStack = super.method_9574(level, pos, state, includeData);
        if (this.spikeMaterial.dropsPlayerLoot() && (class_25862 = level.method_8321(pos)) instanceof SpikeBlockEntity) {
            SpikeBlockEntity blockEntity = (SpikeBlockEntity)class_25862;
            itemStack.method_57365(blockEntity.method_57590());
        }
        return itemStack;
    }

    public class_2561 getDescriptionComponent() {
        return class_2561.method_43471((String)(this.method_63499() + ".description")).method_27692(class_124.field_1080);
    }
}

