/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.phys.shapes;

import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class VoxelUtils {
    private static final double SCALE = 16.0;
    private static final double SCALED_DOWN = 0.0625;

    public static class_243[] scale(class_243[] edges) {
        return (class_243[])Stream.of(edges).map(edge -> edge.method_1021(0.0625)).toArray(class_243[]::new);
    }

    public static class_243[] mirrorX(class_243[] edges) {
        return (class_243[])Stream.of(edges).map(edge -> new class_243(16.0 - edge.field_1352, edge.field_1351, edge.field_1350)).toArray(class_243[]::new);
    }

    public static class_243[] mirrorY(class_243[] edges) {
        return (class_243[])Stream.of(edges).map(edge -> new class_243(edge.field_1352, 16.0 - edge.field_1351, edge.field_1350)).toArray(class_243[]::new);
    }

    public static class_243[] mirrorZ(class_243[] edges) {
        return (class_243[])Stream.of(edges).map(edge -> new class_243(edge.field_1352, edge.field_1351, 16.0 - edge.field_1350)).toArray(class_243[]::new);
    }

    public static class_243[] flipXZ(class_243[] edges) {
        return (class_243[])Stream.of(edges).map(edge -> new class_243(edge.field_1350, edge.field_1351, edge.field_1352)).toArray(class_243[]::new);
    }

    public static class_243[] flipXY(class_243[] edges) {
        return (class_243[])Stream.of(edges).map(edge -> new class_243(edge.field_1351, edge.field_1352, edge.field_1350)).toArray(class_243[]::new);
    }

    public static class_243[] flipYZ(class_243[] edges) {
        return (class_243[])Stream.of(edges).map(edge -> new class_243(edge.field_1352, edge.field_1350, edge.field_1351)).toArray(class_243[]::new);
    }

    public static class_243[] rotate(class_2350 direction, class_243[] edges) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> VoxelUtils.mirrorY(edges);
            case class_2350.field_11036 -> edges;
            case class_2350.field_11043 -> VoxelUtils.mirrorZ(VoxelUtils.flipYZ(edges));
            case class_2350.field_11035 -> VoxelUtils.flipYZ(edges);
            case class_2350.field_11034 -> VoxelUtils.flipXY(edges);
            case class_2350.field_11039 -> VoxelUtils.mirrorX(VoxelUtils.flipXY(edges));
        };
    }

    public static class_265 makeCombinedShape(class_243[] corners) {
        if (corners.length == 0 || corners.length % 2 != 0) {
            throw new IllegalArgumentException("Incorrect number of provided corners");
        }
        class_265 shape = null;
        for (int i = 0; i < corners.length / 2; ++i) {
            int index = 2 * i;
            class_265 boxShape = VoxelUtils.makeBoxShape(corners[index], corners[index + 1]);
            shape = i == 0 ? boxShape : class_259.method_1084((class_265)shape, (class_265)boxShape);
        }
        return shape;
    }

    public static class_265 makeBoxShape(class_243 start, class_243 end) {
        double startX = Math.min(start.field_1352, end.field_1352);
        double startY = Math.min(start.field_1351, end.field_1351);
        double startZ = Math.min(start.field_1350, end.field_1350);
        double endX = Math.max(start.field_1352, end.field_1352);
        double endY = Math.max(start.field_1351, end.field_1351);
        double endZ = Math.max(start.field_1350, end.field_1350);
        return class_2248.method_9541((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
    }

    public static class_243[] makeVectors(double ... values) {
        if (values.length % 3 != 0) {
            throw new IllegalArgumentException("Unable to create proper number of vectors");
        }
        class_243[] array = new class_243[values.length / 3];
        for (int i = 0; i < array.length; ++i) {
            int index = 3 * i;
            array[i] = new class_243(values[index], values[index + 1], values[index + 2]);
        }
        return array;
    }

    public static class_243[] makePyramidEdges(class_243[] corners) {
        if (corners.length != 5) {
            throw new IllegalArgumentException("Constructing a pyramid requires 5 corners");
        }
        return new class_243[]{corners[0], corners[1], corners[1], corners[2], corners[2], corners[3], corners[3], corners[0], corners[0], corners[4], corners[1], corners[4], corners[2], corners[4], corners[3], corners[4]};
    }
}

