/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.spikyspikes.client.renderer.blockentity.state.SpikeRenderState;
import fuzs.spikyspikes.world.level.block.SpikeBlock;
import fuzs.spikyspikes.world.level.block.entity.SpikeBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SpikeRenderer
implements BlockEntityRenderer<SpikeBlockEntity, SpikeRenderState> {
    private final BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
    private final BlockColors blockColors = Minecraft.getInstance().getBlockColors();

    public SpikeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public SpikeRenderState createRenderState() {
        return new SpikeRenderState();
    }

    public void extractRenderState(SpikeBlockEntity blockEntity, SpikeRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, crumblingOverlay);
        renderState.blockColor = this.blockColors.getColor(renderState.blockState, (BlockAndTintGetter)blockEntity.getLevel(), blockEntity.getBlockPos(), 0);
    }

    public void submit(SpikeRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.blockState.getOptionalValue((Property)SpikeBlock.ENCHANTED).orElse(false).booleanValue()) {
            submitNodeCollector.order(1).submitCustomGeometry(poseStack, ItemBlockRenderTypes.getMovingBlockRenderType((BlockState)renderState.blockState), (pose, vertexConsumer) -> this.renderSpike(pose, vertexConsumer, this.blockRenderer.getBlockModel(renderState.blockState), renderState.lightCoords, renderState.blockColor));
            submitNodeCollector.order(2).submitCustomGeometry(poseStack, SpikeRenderer.getFoilRenderType(renderState.blockState), (pose, vertexConsumer) -> this.renderSpike(pose, vertexConsumer, this.blockRenderer.getBlockModel(renderState.blockState), renderState.lightCoords, renderState.blockColor));
            if (renderState.breakProgress != null) {
                submitNodeCollector.order(3).submitCustomGeometry(poseStack, (RenderType)ModelBakery.DESTROY_TYPES.get(renderState.breakProgress.progress()), (pose, vertexConsumer) -> {
                    SheetedDecalTextureGenerator textureGenerator = new SheetedDecalTextureGenerator(vertexConsumer, renderState.breakProgress.cameraPose(), 1.0f);
                    this.renderSpike(pose, (VertexConsumer)textureGenerator, this.blockRenderer.getBlockModel(renderState.blockState), renderState.lightCoords, renderState.blockColor);
                });
            }
        }
    }

    private void renderSpike(PoseStack.Pose pose, VertexConsumer vertexConsumer, BlockStateModel blockStateModel, int packedLight, int color) {
        ModelBlockRenderer.renderModel((PoseStack.Pose)pose, (VertexConsumer)vertexConsumer, (BlockStateModel)blockStateModel, (float)ARGB.redFloat((int)color), (float)ARGB.greenFloat((int)color), (float)ARGB.blueFloat((int)color), (int)packedLight, (int)OverlayTexture.NO_OVERLAY);
    }

    public static RenderType getFoilRenderType(BlockState blockState) {
        return SpikeRenderer.getFoilRenderType(ItemBlockRenderTypes.getMovingBlockRenderType((BlockState)blockState));
    }

    public static RenderType getFoilRenderType(RenderType renderType) {
        return (RenderType)ItemRenderer.getFoilRenderTypes((RenderType)renderType, (boolean)true, (boolean)true).get(1);
    }

    public int getViewDistance() {
        return 256;
    }
}

