/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.data.client;

import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.client.data.v2.models.ModelLocationHelper;
import fuzs.puzzleslib.api.client.data.v2.models.ModelTemplateHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.spikyspikes.SpikySpikes;
import fuzs.spikyspikes.init.ModRegistry;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ModModelProvider
extends AbstractModelProvider {
    public static final ModelTemplate SPIKE_MODEL_TEMPLATE = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)SpikySpikes.id("spike"), (TextureSlot[])new TextureSlot[]{TextureSlot.PARTICLE, TextureSlot.NORTH, TextureSlot.SOUTH, TextureSlot.EAST, TextureSlot.WEST, TextureSlot.DOWN});

    public ModModelProvider(DataProviderContext context) {
        super(context);
    }

    public void addBlockModels(BlockModelGenerators blockModelGenerators) {
        this.createSpikeBlock((Block)ModRegistry.WOODEN_SPIKE_BLOCK.value(), ModelLocationHelper.getBlockTexture((Block)Blocks.STRIPPED_OAK_LOG), ModelLocationHelper.getBlockTexture((Block)Blocks.STRIPPED_OAK_LOG, (String)"_top"), blockModelGenerators);
        this.createSpikeBlock((Block)ModRegistry.STONE_SPIKE_BLOCK.value(), Blocks.SMOOTH_STONE, blockModelGenerators);
        this.createSpikeBlock((Block)ModRegistry.IRON_SPIKE_BLOCK.value(), Blocks.IRON_BLOCK, blockModelGenerators);
        this.createSpikeBlock((Block)ModRegistry.GOLDEN_SPIKE_BLOCK.value(), Blocks.GOLD_BLOCK, blockModelGenerators);
        this.createSpikeBlock((Block)ModRegistry.DIAMOND_SPIKE_BLOCK.value(), Blocks.DIAMOND_BLOCK, blockModelGenerators);
        this.createSpikeBlock((Block)ModRegistry.NETHERITE_SPIKE_BLOCK.value(), Blocks.NETHERITE_BLOCK, blockModelGenerators);
    }

    public final void createSpikeBlock(Block spikeBlock, Block textureBlock, BlockModelGenerators blockModelGenerators) {
        ResourceLocation resourceLocation = ModelLocationHelper.getBlockTexture((Block)textureBlock);
        this.createSpikeBlock(spikeBlock, resourceLocation, resourceLocation, blockModelGenerators);
    }

    public final void createSpikeBlock(Block spikeBlock, ResourceLocation textureLocation, ResourceLocation bottomTextureLocation, BlockModelGenerators blockModelGenerators) {
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.PARTICLE, textureLocation).put(TextureSlot.DOWN, bottomTextureLocation).put(TextureSlot.NORTH, textureLocation).put(TextureSlot.SOUTH, textureLocation).put(TextureSlot.EAST, textureLocation).put(TextureSlot.WEST, textureLocation);
        ResourceLocation resourceLocation = SPIKE_MODEL_TEMPLATE.create(spikeBlock, textureMapping, blockModelGenerators.modelOutput);
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)spikeBlock, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)resourceLocation)).with(BlockModelGenerators.ROTATIONS_COLUMN_WITH_FACING));
    }
}

