/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.mixin;

import fuzs.spikyspikes.handler.SpikeLootingHandler;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantedCountIncreaseFunction.class})
abstract class EnchantedCountIncreaseFunctionMixin {
    @Shadow
    @Final
    private Holder<Enchantment> enchantment;
    @Shadow
    @Final
    private NumberProvider value;
    @Shadow
    @Final
    private int limit;

    EnchantedCountIncreaseFunctionMixin() {
    }

    @Shadow
    private boolean hasLimit() {
        throw new RuntimeException();
    }

    @ModifyVariable(method={"run"}, at=@At(value="STORE"), ordinal=0)
    public int run(int enchantmentLevel, ItemStack itemStack, LootContext lootContext) {
        return SpikeLootingHandler.onComputeEnchantedLootBonus(this.enchantment, enchantmentLevel, lootContext);
    }

    @Inject(method={"run"}, at={@At(value="HEAD")})
    public void run(ItemStack stack, LootContext context, CallbackInfoReturnable<ItemStack> callback) {
        int enchantmentLevel;
        if (!(context.getOptionalParameter(LootContextParams.ATTACKING_ENTITY) instanceof LivingEntity) && (enchantmentLevel = SpikeLootingHandler.onComputeEnchantedLootBonus(this.enchantment, 0, context)) != 0) {
            float f = (float)enchantmentLevel * this.value.getFloat(context);
            stack.grow(Math.round(f));
            if (this.hasLimit()) {
                stack.limitSize(this.limit);
            }
        }
    }
}

