/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.util;

import fuzs.spikyspikes.world.phys.shapes.CustomOutlineShape;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class DestroyEffectsHelper {
    private DestroyEffectsHelper() {
    }

    public static boolean addDestroyEffects(BlockState blockState, Level level, BlockPos blockPos, ParticleEngine particleEngine) {
        VoxelShape voxelShape = blockState.getShape((BlockGetter)level, blockPos);
        if (voxelShape instanceof CustomOutlineShape) {
            CustomOutlineShape voxelCollection = (CustomOutlineShape)voxelShape;
            voxelCollection.forAllParticleBoxes((x1, y1, z1, x2, y2, z2) -> {
                double d1 = Math.min(1.0, x2 - x1);
                double d2 = Math.min(1.0, y2 - y1);
                double d3 = Math.min(1.0, z2 - z1);
                int i = Math.max(2, Mth.ceil((double)(d1 / 0.25)));
                int j = Math.max(2, Mth.ceil((double)(d2 / 0.25)));
                int k = Math.max(2, Mth.ceil((double)(d3 / 0.25)));
                for (int l = 0; l < i; ++l) {
                    for (int i1 = 0; i1 < j; ++i1) {
                        for (int j1 = 0; j1 < k; ++j1) {
                            double d4 = ((double)l + 0.5) / (double)i;
                            double d5 = ((double)i1 + 0.5) / (double)j;
                            double d6 = ((double)j1 + 0.5) / (double)k;
                            double d7 = d4 * d1 + x1;
                            double d8 = d5 * d2 + y1;
                            double d9 = d6 * d3 + z1;
                            particleEngine.add((Particle)new TerrainParticle((ClientLevel)level, (double)blockPos.getX() + d7, (double)blockPos.getY() + d8, (double)blockPos.getZ() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, blockState, blockPos));
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }
}

