/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.spikyspikes.init.ModRegistry;
import fuzs.spikyspikes.world.damagesource.SpikeDamageSource;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import fuzs.spikyspikes.world.level.block.entity.SpikeBlockEntity;
import fuzs.spikyspikes.world.phys.shapes.CustomOutlineShape;
import fuzs.spikyspikes.world.phys.shapes.VoxelUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpikeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<SpikeBlock> CODEC = SpikeBlock.spikeCodec(SpikeBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final BooleanProperty ENCHANTED = BooleanProperty.create((String)"enchanted");
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), SpikeBlock::makeVisualShape));
    private static final Map<Direction, VoxelShape> COLLISION_SHAPE_BY_DIRECTION = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> SpikeBlock.makeCollisionShape(direction, false)));
    private static final Map<Direction, VoxelShape> INTERACTION_SHAPE_BY_DIRECTION = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> SpikeBlock.makeCollisionShape(direction, true)));
    private final SpikeMaterial spikeMaterial;

    public SpikeBlock(SpikeMaterial spikeMaterial, BlockBehaviour.Properties properties) {
        super(properties);
        this.spikeMaterial = spikeMaterial;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue(FACING, (Comparable)Direction.UP)).setValue((Property)ENCHANTED, (Comparable)Boolean.FALSE));
    }

    protected static <T extends SpikeBlock> MapCodec<T> spikeCodec(BiFunction<SpikeMaterial, BlockBehaviour.Properties, T> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpikeMaterial.CODEC.fieldOf("material").forGetter(SpikeBlock::getSpikeMaterial), (App)SpikeBlock.propertiesCodec()).apply((Applicative)instance, factory));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public SpikeMaterial getSpikeMaterial() {
        return this.spikeMaterial;
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)ENCHANTED) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    private static VoxelShape makeVisualShape(Direction direction) {
        VoxelShape shape = SpikeBlock.makeStaircasePyramid(direction, 8, 2.0);
        Vec3[] outlineVectors = VoxelUtils.makePyramidEdges(VoxelUtils.makeVectors(0.0, 0.0, 0.0, 16.0, 0.0, 0.0, 16.0, 0.0, 16.0, 0.0, 0.0, 16.0, 8.0, 16.0, 8.0));
        return new CustomOutlineShape(shape, VoxelUtils.scale(VoxelUtils.rotate(direction, outlineVectors)));
    }

    private static VoxelShape makeStaircasePyramid(Direction direction, int layers, double layerHeight) {
        Vec3[] vectors = new Vec3[layers * 2];
        int i = 0;
        int j = layers;
        while (i < layers) {
            vectors[2 * i] = new Vec3(8.0 - (double)j, (double)i * layerHeight, 8.0 - (double)j);
            vectors[2 * i + 1] = new Vec3(8.0 + (double)j, (double)(i + 1) * layerHeight, 8.0 + (double)j);
            ++i;
            --j;
        }
        return VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, vectors));
    }

    private static VoxelShape makeCollisionShape(Direction direction, boolean fullHeight) {
        Vec3[] vectors = VoxelUtils.makeVectors(1.0, 0.0, 1.0, 15.0, fullHeight ? 16.0 : 11.0, 15.0);
        return VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, vectors));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return SHAPE_BY_DIRECTION.get(blockState.getValue(FACING));
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return COLLISION_SHAPE_BY_DIRECTION.get(blockState.getValue(FACING));
    }

    public VoxelShape getVisualShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return this.getShape(blockState, level, blockPos, context);
    }

    public VoxelShape getInteractionShape(BlockState blockState, BlockGetter level, BlockPos blockPos) {
        return INTERACTION_SHAPE_BY_DIRECTION.get(blockState.getValue(FACING));
    }

    public VoxelShape getBlockSupportShape(BlockState blockState, BlockGetter level, BlockPos blockPos) {
        return Shapes.empty();
    }

    protected VoxelShape getOcclusionShape(BlockState state) {
        return this.getRenderShape(state) != RenderShape.INVISIBLE ? super.getOcclusionShape(state) : Shapes.empty();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue(FACING);
        BlockPos otherPos = pos.relative(direction.getOpposite());
        if (direction == Direction.UP) {
            return SpikeBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)otherPos);
        }
        return level.getBlockState(otherPos).isFaceSturdy((BlockGetter)level, otherPos, direction);
    }

    protected BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos blockPos, Direction direction, BlockPos neighborBlockPos, BlockState neighborBlockState, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return direction == ((Direction)blockState.getValue(FACING)).getOpposite() && !this.canSurvive(blockState, levelReader, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, levelReader, scheduledTickAccess, blockPos, direction, neighborBlockPos, neighborBlockState, randomSource);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(blockPos).getType() == Fluids.WATER))).setValue((Property)ENCHANTED, (Comparable)Boolean.valueOf(!((ItemEnchantments)context.getItemInHand().getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty()));
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!(blockState = (BlockState)blockState.setValue(FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)level, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue(FACING, (Comparable)rotation.rotate((Direction)blockState.getValue(FACING)));
    }

    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation((Direction)blockState.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, ENCHANTED});
    }

    public boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    protected void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity, InsideBlockEffectApplier insideBlockEffectApplier) {
        block10: {
            LivingEntity livingEntity;
            ServerLevel serverLevel;
            block11: {
                if (!(level instanceof ServerLevel)) break block10;
                serverLevel = (ServerLevel)level;
                if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isAlive() || livingEntity.getType().is(ModRegistry.SPIKE_DAMAGE_IMMUNE_ENTITY_TYPE_TAG)) break block10;
                if (!(livingEntity instanceof Player)) break block11;
                Player player = (Player)livingEntity;
                if (player.getAbilities().instabuild || player.getAbilities().invulnerable) break block10;
            }
            if ((this.spikeMaterial.dealsFinalBlow() || livingEntity.getHealth() > this.spikeMaterial.damageAmount()) && (this.spikeMaterial.hurtsPlayers() || !(livingEntity instanceof Player))) {
                if (this.spikeMaterial.dropsPlayerLoot()) {
                    BlockEntity blockEntity = level.getBlockEntity(blockPos);
                    if (blockEntity instanceof SpikeBlockEntity) {
                        SpikeBlockEntity blockEntity2 = (SpikeBlockEntity)blockEntity;
                        SpikeBlockEntity.attack(serverLevel, blockPos, level.getBlockState(blockPos), blockEntity2, livingEntity, this.spikeMaterial);
                    }
                } else {
                    boolean doMobLoot = serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
                    if (!this.spikeMaterial.dropsMobLoot()) {
                        ((GameRules.BooleanValue)serverLevel.getGameRules().getRule(GameRules.RULE_DOMOBLOOT)).set(false, level.getServer());
                    }
                    livingEntity.hurtServer(serverLevel, SpikeDamageSource.source(ModRegistry.SPIKE_DAMAGE_TYPE, level, blockPos), this.spikeMaterial.damageAmount());
                    if (!this.spikeMaterial.dropsMobLoot()) {
                        ((GameRules.BooleanValue)serverLevel.getGameRules().getRule(GameRules.RULE_DOMOBLOOT)).set(doMobLoot, level.getServer());
                    }
                    if (!livingEntity.isAlive() && this.spikeMaterial.dropsExperience()) {
                        livingEntity.setLastHurtByPlayer((EntityReference)null, 100);
                        livingEntity.dropExperience(serverLevel, null);
                        livingEntity.skipDropExperience();
                    }
                }
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SpikeBlockEntity(pos, state);
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        BlockEntity blockEntity;
        ItemStack itemStack = super.getCloneItemStack(level, pos, state, includeData);
        if (this.spikeMaterial.dropsPlayerLoot() && (blockEntity = level.getBlockEntity(pos)) instanceof SpikeBlockEntity) {
            SpikeBlockEntity blockEntity2 = (SpikeBlockEntity)blockEntity;
            itemStack.applyComponents(blockEntity2.collectComponents());
        }
        return itemStack;
    }

    public Component getDescriptionComponent() {
        return Component.translatable((String)(this.getDescriptionId() + ".description")).withStyle(ChatFormatting.GRAY);
    }
}

