/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block.entity;

import fuzs.spikyspikes.SpikySpikes;
import fuzs.spikyspikes.init.ModRegistry;
import fuzs.spikyspikes.world.level.block.SpikeBlock;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import fuzs.spikyspikes.world.level.block.entity.FakePlayerAttackHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class SpikeBlockEntity
extends BlockEntity {
    public static final String ENCHANTMENTS_TAG = SpikySpikes.id("enchantments").toString();
    public static final String REPAIR_COST_TAG = SpikySpikes.id("repair_cost").toString();
    private ItemEnchantments enchantments = ItemEnchantments.EMPTY;
    private int repairCost;

    public SpikeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.SPIKE_BLOCK_ENTITY_TYPE.value(), blockPos, blockState);
    }

    public static void attack(ServerLevel level, BlockPos pos, BlockState state, SpikeBlockEntity blockEntity, LivingEntity entity, SpikeMaterial material) {
        FakePlayerAttackHelper.attack((Entity)entity, level, pos, (Direction)state.getValue(SpikeBlock.FACING), material.damageAmount(), blockEntity.enchantments, material.hurtsPlayers());
    }

    public void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.enchantments = valueInput.read(ENCHANTMENTS_TAG, ItemEnchantments.CODEC).orElse(ItemEnchantments.EMPTY);
        this.repairCost = valueInput.getIntOr(REPAIR_COST_TAG, 0);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        if (!this.enchantments.isEmpty()) {
            valueOutput.store(ENCHANTMENTS_TAG, ItemEnchantments.CODEC, (Object)this.enchantments);
        }
        valueOutput.putInt(REPAIR_COST_TAG, this.repairCost);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    protected void applyImplicitComponents(DataComponentGetter dataComponentGetter) {
        super.applyImplicitComponents(dataComponentGetter);
        this.enchantments = (ItemEnchantments)dataComponentGetter.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        this.repairCost = (Integer)dataComponentGetter.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.STORED_ENCHANTMENTS, (Object)this.enchantments);
        components.set(DataComponents.REPAIR_COST, (Object)this.repairCost);
    }

    public void removeComponentsFromTag(ValueOutput valueOutput) {
        super.removeComponentsFromTag(valueOutput);
        valueOutput.discard(ENCHANTMENTS_TAG);
        valueOutput.discard(REPAIR_COST_TAG);
    }
}

