/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.phys.shapes;

import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelUtils {
    private static final double SCALE = 16.0;
    private static final double SCALED_DOWN = 0.0625;

    public static Vec3[] scale(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> edge.scale(0.0625)).toArray(Vec3[]::new);
    }

    public static Vec3[] mirrorX(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(16.0 - edge.x, edge.y, edge.z)).toArray(Vec3[]::new);
    }

    public static Vec3[] mirrorY(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.x, 16.0 - edge.y, edge.z)).toArray(Vec3[]::new);
    }

    public static Vec3[] mirrorZ(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.x, edge.y, 16.0 - edge.z)).toArray(Vec3[]::new);
    }

    public static Vec3[] flipXZ(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.z, edge.y, edge.x)).toArray(Vec3[]::new);
    }

    public static Vec3[] flipXY(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.y, edge.x, edge.z)).toArray(Vec3[]::new);
    }

    public static Vec3[] flipYZ(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.x, edge.z, edge.y)).toArray(Vec3[]::new);
    }

    public static Vec3[] rotate(Direction direction, Vec3[] edges) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> VoxelUtils.mirrorY(edges);
            case Direction.UP -> edges;
            case Direction.NORTH -> VoxelUtils.mirrorZ(VoxelUtils.flipYZ(edges));
            case Direction.SOUTH -> VoxelUtils.flipYZ(edges);
            case Direction.EAST -> VoxelUtils.flipXY(edges);
            case Direction.WEST -> VoxelUtils.mirrorX(VoxelUtils.flipXY(edges));
        };
    }

    public static VoxelShape makeCombinedShape(Vec3[] corners) {
        if (corners.length == 0 || corners.length % 2 != 0) {
            throw new IllegalArgumentException("Incorrect number of provided corners");
        }
        VoxelShape shape = null;
        for (int i = 0; i < corners.length / 2; ++i) {
            int index = 2 * i;
            VoxelShape boxShape = VoxelUtils.makeBoxShape(corners[index], corners[index + 1]);
            shape = i == 0 ? boxShape : Shapes.or((VoxelShape)shape, (VoxelShape)boxShape);
        }
        return shape;
    }

    public static VoxelShape makeBoxShape(Vec3 start, Vec3 end) {
        double startX = Math.min(start.x, end.x);
        double startY = Math.min(start.y, end.y);
        double startZ = Math.min(start.z, end.z);
        double endX = Math.max(start.x, end.x);
        double endY = Math.max(start.y, end.y);
        double endZ = Math.max(start.z, end.z);
        return Block.box((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
    }

    public static Vec3[] makeVectors(double ... values) {
        if (values.length % 3 != 0) {
            throw new IllegalArgumentException("Unable to create proper number of vectors");
        }
        Vec3[] array = new Vec3[values.length / 3];
        for (int i = 0; i < array.length; ++i) {
            int index = 3 * i;
            array[i] = new Vec3(values[index], values[index + 1], values[index + 2]);
        }
        return array;
    }

    public static Vec3[] makePyramidEdges(Vec3[] corners) {
        if (corners.length != 5) {
            throw new IllegalArgumentException("Constructing a pyramid requires 5 corners");
        }
        return new Vec3[]{corners[0], corners[1], corners[1], corners[2], corners[2], corners[3], corners[3], corners[0], corners[0], corners[4], corners[1], corners[4], corners[2], corners[4], corners[3], corners[4]};
    }
}

