/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.client.renderer.block.model;

import fuzs.puzzleslib.api.client.renderer.v1.model.QuadUtils;
import fuzs.spikyspikes.SpikySpikes;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_10419;
import net.minecraft.class_1047;
import net.minecraft.class_1059;
import net.minecraft.class_10802;
import net.minecraft.class_10813;
import net.minecraft.class_10817;
import net.minecraft.class_10820;
import net.minecraft.class_10821;
import net.minecraft.class_1100;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_9826;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SpikeModelGenerator
implements class_1100 {
    public static final class_2960 BUILTIN_SPIKE_MODEL = SpikySpikes.id("builtin/spike");
    public static final class_10419.class_10420 TEXTURE_SLOTS = new class_10419.class_10420.class_10421().method_65548(class_2350.field_11036.method_15434(), new class_4730(class_1059.field_5275, class_1047.method_4539())).method_65547();
    private static final List<class_785> ELEMENTS = Collections.singletonList(SpikeModelGenerator.createCubeElement());

    public class_10419.class_10420 comp_3743() {
        return TEXTURE_SLOTS;
    }

    public class_10820 comp_3739() {
        return SpikeModelGenerator::bake;
    }

    private static class_785 createCubeElement() {
        class_783.class_10800 blockFaceUV = new class_783.class_10800(0.0f, 0.0f, 16.0f, 16.0f);
        EnumMap<class_2350, class_783> map = new EnumMap<class_2350, class_783>(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            map.put(direction, new class_783(direction, -1, direction.method_15434(), blockFaceUV, class_10821.field_57029));
        }
        return new class_785((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(16.0f, 16.0f, 16.0f), map);
    }

    public static class_10817 bake(class_10419 textureSlots, class_7775 modelBaker, class_3665 modelState, class_10813 modelDebugName) {
        class_10817 quadCollection = class_10802.method_67934(ELEMENTS, (class_10419)textureSlots, (class_9826)modelBaker.method_65732(), (class_3665)modelState, (class_10813)modelDebugName);
        return SpikeModelGenerator.modifyBakedModel(quadCollection, modelState, SpikeModelGenerator::finalizeBakedQuad);
    }

    private static class_10817 modifyBakedModel(class_10817 quadCollection, class_3665 modelState, BakedQuadFinalizer bakedQuadFinalizer) {
        Map bakedQuadMap = class_156.method_63541(class_2350.class, direction -> (class_777)quadCollection.method_68049(direction).getFirst());
        class_10817.class_10818 builder = new class_10817.class_10818();
        for (class_777 bakedQuad2 : quadCollection.method_68049(null)) {
            builder.method_68051(bakedQuad2);
        }
        Function directionRotator = class_156.method_34866(direction -> class_2350.method_23225((Matrix4fc)modelState.method_3509().method_22936(), (class_2350)direction));
        for (Map.Entry entry : bakedQuadMap.entrySet()) {
            bakedQuadFinalizer.finalizeBakedQuad(class_2350.method_23225((Matrix4fc)modelState.method_3509().method_68076().invert(), (class_2350)((class_2350)entry.getKey())), (class_777)entry.getValue(), directionRotator::apply, (direction, bakedQuad) -> {
                if (direction != null) {
                    builder.method_68053(direction, bakedQuad);
                } else {
                    builder.method_68051(bakedQuad);
                }
            });
        }
        return builder.method_68050();
    }

    private static void finalizeBakedQuad(class_2350 direction, class_777 bakedQuad, UnaryOperator<class_2350> directionRotator, BiConsumer<@Nullable class_2350, class_777> bakedQuadConsumer) {
        if (direction != class_2350.field_11036) {
            bakedQuad = QuadUtils.copy((class_777)bakedQuad);
            if (direction.method_10166().method_10179()) {
                int[] maxVertexIndices = ((class_2350)directionRotator.apply(class_2350.field_11036)).method_10171() == class_2350.field_11036.method_10171() ? SpikeModelGenerator.getMaxVertexIndices(bakedQuad, ((class_2350)directionRotator.apply(class_2350.field_11036)).method_10166()) : SpikeModelGenerator.getMinVertexIndices(bakedQuad, ((class_2350)directionRotator.apply(class_2350.field_11036)).method_10166());
                for (int vertexIndex : maxVertexIndices) {
                    SpikeModelGenerator.setQuadPosition(bakedQuad, vertexIndex, ((class_2350)directionRotator.apply(class_2350.field_11034)).method_10166(), 0.5f);
                    SpikeModelGenerator.setQuadPosition(bakedQuad, vertexIndex, ((class_2350)directionRotator.apply(class_2350.field_11035)).method_10166(), 0.5f);
                    float u0 = QuadUtils.getU((class_777)bakedQuad, (int)maxVertexIndices[0]);
                    float u1 = QuadUtils.getU((class_777)bakedQuad, (int)maxVertexIndices[1]);
                    QuadUtils.setU((class_777)bakedQuad, (int)vertexIndex, (float)class_3532.method_16439((float)0.5f, (float)u0, (float)u1));
                }
                QuadUtils.fillNormal((class_777)bakedQuad);
                bakedQuadConsumer.accept(null, bakedQuad);
            } else {
                bakedQuadConsumer.accept((class_2350)directionRotator.apply(direction), bakedQuad);
            }
        }
    }

    public static int[] getMaxVertexIndices(class_777 bakedQuad, class_2350.class_2351 axis) {
        IntArrayList maxVertexIndices = new IntArrayList();
        float maxValue = Float.MIN_VALUE;
        for (int i = 0; i < 4; ++i) {
            float positionComponent = SpikeModelGenerator.getQuadPosition(bakedQuad, i, axis);
            if (positionComponent > maxValue) {
                maxVertexIndices.clear();
                maxValue = positionComponent;
            }
            if (positionComponent != maxValue) continue;
            maxVertexIndices.add(i);
        }
        return maxVertexIndices.toIntArray();
    }

    public static int[] getMinVertexIndices(class_777 bakedQuad, class_2350.class_2351 axis) {
        IntArrayList minVertexIndices = new IntArrayList();
        float minValue = Float.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            float positionComponent = SpikeModelGenerator.getQuadPosition(bakedQuad, i, axis);
            if (positionComponent < minValue) {
                minVertexIndices.clear();
                minValue = positionComponent;
            }
            if (positionComponent != minValue) continue;
            minVertexIndices.add(i);
        }
        return minVertexIndices.toIntArray();
    }

    public static float getQuadPosition(class_777 bakedQuad, int vertexIndex, class_2350.class_2351 axis) {
        Vector3f vector3f = QuadUtils.getPosition((class_777)bakedQuad, (int)vertexIndex);
        return (float)axis.method_10172((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z());
    }

    public static void setQuadPosition(class_777 bakedQuad, int vertexIndex, class_2350.class_2351 axis, float positionComponent) {
        Vector3f vector3f = QuadUtils.getPosition((class_777)bakedQuad, (int)vertexIndex);
        vector3f.sub((Vector3fc)vector3f.mul((Vector3fc)axis.method_64922().method_23955(), new Vector3f()));
        QuadUtils.setPosition((class_777)bakedQuad, (int)vertexIndex, (Vector3f)vector3f.add((Vector3fc)axis.method_64922().method_23955().mul(positionComponent)));
    }

    @FunctionalInterface
    public static interface BakedQuadFinalizer {
        public void finalizeBakedQuad(class_2350 var1, class_777 var2, UnaryOperator<class_2350> var3, BiConsumer<@Nullable class_2350, class_777> var4);
    }
}

