/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block.entity;

import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import fuzs.spikyspikes.init.ModRegistry;
import fuzs.spikyspikes.world.damagesource.SpikeDamageSource;
import fuzs.spikyspikes.world.level.block.entity.BlockEnchantmentHelper;
import java.util.function.Predicate;
import net.minecraft.class_10583;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2616;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9636;

public final class FakePlayerAttackHelper {
    private FakePlayerAttackHelper() {
    }

    public static void attack(class_1297 entity, class_3218 serverLevel, class_2338 pos, class_2350 direction, float attackDamage, class_9304 itemEnchantments, boolean hurtPlayers) {
        if (entity.method_5732()) {
            class_1282 damageSource = SpikeDamageSource.source(ModRegistry.SPIKE_DAMAGE_TYPE, (class_1937)serverLevel, pos, itemEnchantments);
            float enchantedDamage = BlockEnchantmentHelper.modifyDamage(serverLevel, entity, damageSource, attackDamage, itemEnchantments) - attackDamage;
            if (attackDamage > 0.0f || enchantedDamage > 0.0f) {
                attackDamage += enchantedDamage;
                boolean setOnFire = false;
                if (entity instanceof class_1309 && itemEnchantments.method_57534().stream().anyMatch(holder -> holder.method_40220(class_9636.field_51552)) && !entity.method_5809()) {
                    setOnFire = true;
                    entity.method_5639(1.0f);
                }
                if (FakePlayerAttackHelper.hurt(serverLevel, entity, attackDamage, damageSource)) {
                    float attackKnockback = (float)BlockEnchantmentHelper.getAttributeValue((class_6880<class_1320>)class_5134.field_23722, itemEnchantments);
                    attackKnockback = BlockEnchantmentHelper.modifyKnockback(serverLevel, entity, damageSource, attackKnockback, itemEnchantments);
                    FakePlayerAttackHelper.knockback(entity, attackKnockback * 0.5f, direction, serverLevel.method_8409());
                    FakePlayerAttackHelper.sweepAttack(entity, attackDamage, serverLevel, pos, direction, damageSource, hurtPlayers, itemEnchantments);
                    BlockEnchantmentHelper.doPostAttackEffects(serverLevel, entity, damageSource, itemEnchantments);
                    if (enchantedDamage > 0.0f) {
                        serverLevel.method_14178().method_18751(entity, (class_2596)new class_2616(entity, 5));
                    }
                } else if (setOnFire) {
                    entity.method_5646();
                }
            }
        }
    }

    public static void knockback(class_1297 entity, double knockbackStrength, class_2350 direction, class_5819 random) {
        if (entity instanceof class_1309) {
            knockbackStrength *= 1.0 - ((class_1309)entity).method_45325(class_5134.field_23718);
        }
        if (knockbackStrength > 0.0) {
            class_243 deltaMovement = entity.method_18798();
            class_243 normalVec = direction.method_62676();
            int axisStep = direction.method_10153().method_10171().method_10181();
            class_243 offsetVec = new class_243((double)axisStep, (double)axisStep, (double)axisStep).method_1019(normalVec).method_18805(random.method_43059(), random.method_43059(), random.method_43059());
            class_243 knockbackVec = normalVec.method_1019(offsetVec).method_1029().method_1021(knockbackStrength);
            entity.method_18800(deltaMovement.field_1352 / 2.0 + knockbackVec.field_1352, Math.min(0.4, deltaMovement.field_1351 / 2.0 + knockbackVec.field_1351), deltaMovement.field_1350 / 2.0 + knockbackVec.field_1350);
            entity.field_6007 = true;
        }
    }

    public static boolean hurt(class_3218 serverLevel, class_1297 entity, float attackDamage, class_1282 damageSource) {
        class_243 oldMovement = entity.method_18798();
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_6015(null);
            mob.method_29505((class_10583)null, 100);
            mob.method_5980(null);
        }
        if (entity.method_64397(serverLevel, damageSource, attackDamage)) {
            entity.method_18799(oldMovement);
            return true;
        }
        return false;
    }

    public static void sweepAttack(class_1297 entity, float attackDamage, class_3218 level, class_2338 pos, class_2350 direction, class_1282 damageSource, boolean hurtPlayers, class_9304 itemEnchantments) {
        double sweepingDamageRatio = BlockEnchantmentHelper.getAttributeValue((class_6880<class_1320>)class_5134.field_51577, itemEnchantments);
        if (sweepingDamageRatio != ((class_1320)class_5134.field_51577.comp_349()).method_6169()) {
            float sweepingDamage = 1.0f + (float)sweepingDamageRatio * attackDamage;
            Predicate<class_1309> filter = hurtPlayers ? class_1301.field_6155 : Predicate.not(class_1657.class::isInstance);
            for (class_1309 livingEntity : level.method_8390(class_1309.class, entity.method_5829().method_1009(1.0, 0.25, 1.0), filter)) {
                if (livingEntity == entity || livingEntity instanceof class_1531 && ((class_1531)livingEntity).method_6912() || !(pos.method_19770((class_2374)livingEntity.method_73189()) < 9.0)) continue;
                float hurtAmount = BlockEnchantmentHelper.modifyDamage(level, (class_1297)livingEntity, damageSource, sweepingDamage, itemEnchantments);
                if (itemEnchantments.method_57536(LookupHelper.lookup((class_4538)level, (class_5321)class_7924.field_41265, (class_5321)class_1893.field_9121)) > 0) {
                    FakePlayerAttackHelper.knockback((class_1297)livingEntity, 0.4f, direction, level.method_8409());
                }
                livingEntity.method_64419(damageSource, hurtAmount);
                BlockEnchantmentHelper.doPostAttackEffects(level, (class_1297)livingEntity, damageSource, itemEnchantments);
            }
            class_2338 onFrontPos = pos.method_10093(direction);
            level.method_43128(null, (double)onFrontPos.method_10263() + 0.5, (double)onFrontPos.method_10264() + 0.5, (double)onFrontPos.method_10260() + 0.5, class_3417.field_14706, class_3419.field_15245, 1.0f, 1.0f);
            level.method_65096((class_2394)class_2398.field_11227, (double)onFrontPos.method_10263() + 0.5, (double)onFrontPos.method_10264() + 0.5, (double)onFrontPos.method_10260() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

